package com.xebialabs.xlplatform.synthetic.yaml;

import java.util.*;
import com.fasterxml.jackson.databind.JsonNode;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;

public class JsonSpecification {

    protected final String name;
    protected final JsonNode node;

    public JsonSpecification(String name, JsonNode node) {
        this.name = name;
        this.node = node;
    }

    //
    // Common methods
    //

    public Optional<String> getLabel() {
        return getOptionalString("label");
    }

    public Optional<String> getDescription() {
        return getOptionalString("description");
    }

    public List<ValidationRuleSpecification> getValidationRules() {
        List<ValidationRuleSpecification> rules = new ArrayList<>();
        if (!node.has("rules")) {
            return rules;
        }

        for (JsonNode ruleNode : node.get("rules")) {
            rules.add(new JsonValidationRuleSpecification(ruleNode));
        }
        return rules;
    }

    //
    // Helper methods to access JSON
    //

    protected Optional<String> getOptionalString(String property) {
        return getOptionalString(property, null);
    }

    protected Optional<String> getOptionalString(String property, String defaultValue) {
        if (node.has(property)) {
            return Optional.of(node.get(property).asText());
        }
        return Optional.ofNullable(defaultValue);
    }

    protected Optional<Boolean> getOptionalBoolean(String property) {
        return getOptionalBoolean(property, false);
    }

    protected Optional<Boolean> getOptionalBoolean(String property, boolean defaultValue) {
        if (node.has(property)) {
            return Optional.of(node.get(property).booleanValue());
        }
        return Optional.of(defaultValue);
    }

    protected Optional<Type> getOptionalType(String property) {
        if (node.has(property)) {
            String typeName = node.get(property).asText();
            return Optional.of(Type.valueOf(typeName));
        }
        return Optional.empty();
    }

    protected List<String> getStringValues(String property) {
        List<String> aliases = new ArrayList<>();

        if (node.has(property)) {
            node.get(property).forEach(value ->
                    aliases.add(value.asText())
            );
        }

        return aliases;
    }

    protected Map<String, String> toMap(Set<String> reservedNames) {
        Map<String, String> attributes = new LinkedHashMap<>();

        Iterator<String> keys = node.fieldNames();
        while (keys.hasNext()) {
            String key = keys.next();
            if (reservedNames.contains(key)) {
                continue;
            }

            attributes.put(key, node.get(key).asText());
        }

        return attributes;
    }

    protected List<JsonPropertySpecification> getProperties(String propertiesLabel) {
        List<JsonPropertySpecification> properties = new ArrayList<>();
        if (!node.has(propertiesLabel)) {
            return properties;
        }

        JsonNode propNodes = node.get(propertiesLabel);
        Iterator<String> iter = propNodes.fieldNames();
        while (iter.hasNext()) {
            String propertyName = iter.next();
            properties.add(new JsonPropertySpecification(propertyName, propNodes.get(propertyName)));
        }

        return properties;
    }

}
