package com.xebialabs.xlplatform.synthetic.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import com.fasterxml.jackson.databind.JsonNode;

import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.TypeName;

public class JsonMethodSpecification extends JsonSpecification implements MethodSpecification {

    public JsonMethodSpecification(String name, JsonNode node) {
        super(name, node);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public List<PropertySpecification> getParameters() {
        List<PropertySpecification> parameters = new ArrayList<>();
        parameters.addAll(getProperties("parameters"));

        return parameters;
    }

    @Override
    public Optional<String> getDelegate() {
        return getOptionalString("delegate");
    }

    @Override
    public Optional<TypeName> getParameterType() {
        return getOptionalType("parameters-type");
    }

    @Override
    public Map<String, String> getAttributes() {
        return toMap(RESERVED_ATTRIBUTE_NAMES);
    }
}
