package com.xebialabs.deployit.booter.local;

import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.deployit.plugin.api.reflect.Type;

class SyntheticLocalDescriptor extends LocalDescriptor {

    private GeneratedDeployableSpecification generatedDeployableSpec;

    public SyntheticLocalDescriptor(TypeSpecification typeSpec) {
        Type type = typeSpec.getTypeName().toType();
        setType(type);
        initSynthetic(typeSpec);
        initHierarchy();
        resolveIcon();
    }

    private void initSynthetic(TypeSpecification typeSpec) {
        Type superType = typeSpec.getSuperType().toType();
        addSuperClass(superType);
        setLabel(typeSpec.getLabel().orElse(toLabel(getType())));
        setDescription(typeSpec.getDescription().orElse("Description unavailable"));
        setVirtual(typeSpec.getVirtual().orElse(false));
        setVersioned(typeSpec.getVersioned().orElse(superType.getDescriptor().isVersioned()));
        setInspectable(typeSpec.getInspectable().orElse(false));
        typeSpec.getIcon().ifPresent(icon -> {
            this.setIcon(icon);
            this.setOwnIcon(true);
        });
        setRootName(typeSpec.getRoot());
        typeSpec.getContainerType().ifPresent(typeName -> setContainerType(typeName.toType()));
        typeSpec.getDeployedType().ifPresent(typeName -> setDeployableType(typeName.toType()));
        validators.addAll(createValidators(typeSpec.getValidationRules(), getType()));
        verifications.addAll(createVerifications(typeSpec.getVerifications(), getType()));
        typeSpec.getControlTasks().forEach(this::validateAndAddControlTask);
        typeSpec.getCreator().ifPresent(spec -> setCreator(LocalCreatorDescriptor.from(this, spec.getDelegate(), spec.getAttributes())));
        getPropertyDescriptors(typeSpec.getProperties()).forEach(this::overrideOrAddPropertyDescriptor);
        generatedDeployableSpec = typeSpec.getGeneratedDeployableDescription();
    }

    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        return generatedDeployableSpec;
    }
}
