/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.booter.local.GlobalContextManager;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGlobalContextManager
implements GlobalContextManager {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Function<String, GlobalContext.Value> COMPUTE_FUNCTION = s -> new GlobalContext.Value("", null);
    private Map<String, GlobalContext.Value> context;

    @Override
    public GlobalContextManager withContext(Map<String, GlobalContext.Value> context) {
        this.context = context;
        return this;
    }

    protected void addContextEntries(Map<String, Object> properties) {
        properties.forEach(this::addContextEntry);
    }

    protected void addContextEntry(Object key, Object value) {
        GlobalContext.Value contextValue = this.context.computeIfAbsent(key.toString(), COMPUTE_FUNCTION);
        this.context.put(key.toString(), new GlobalContext.ExplicitValue(contextValue.description, value.toString()));
    }

    protected Stream<Pair> getContextEntries() {
        ArrayList<String> keys = new ArrayList<String>(this.context.keySet());
        return keys.stream().sorted().map(key -> new Pair((String)key, this.context.computeIfAbsent((String)key, COMPUTE_FUNCTION)));
    }

    @Override
    public void validateValues(File configFile) {
        List<String> messages = this.validateContextEntries();
        if (!messages.isEmpty()) {
            String join = (String)messages.stream().reduce((s, t) -> s + "\n" + t).get();
            this.logger.error(join);
            String errorMessage = "Could not initialize the default values, please look at the log and correct the configuration file \n" + join;
            if (configFile != null) {
                errorMessage = "Could not initialize the default values, please look at the log and correct the defaults file: " + configFile + "\n" + join;
            }
            throw new IllegalStateException(errorMessage);
        }
    }

    protected List<String> validateContextEntries() {
        ArrayList<String> messages = new ArrayList<String>();
        for (String prop : this.context.keySet()) {
            PropertyDescriptor propertyDescriptor;
            Descriptor descriptor;
            int i = prop.lastIndexOf(46);
            String type = prop.substring(0, i);
            String propertyName = prop.substring(i + 1);
            Type tType = Type.valueOf((String)type);
            if (!DescriptorRegistry.exists((Type)tType) || (descriptor = DescriptorRegistry.getDescriptor((Type)tType)).isVirtual() || (propertyDescriptor = descriptor.getPropertyDescriptor(propertyName)) == null) continue;
            try {
                propertyDescriptor.getDefaultValue();
                if (!propertyDescriptor.isRequired() || !propertyDescriptor.isHidden() || !Strings.isEmpty(GlobalContext.lookup(propertyDescriptor))) continue;
                messages.add(String.format("Cannot register empty default value for hidden required property [%s]", prop));
            }
            catch (RuntimeException re) {
                messages.add(String.format("Incorrect default registered: [%s] with value %s", prop, this.context.computeIfAbsent(prop, COMPUTE_FUNCTION).getValue()));
            }
        }
        return messages;
    }

    protected String header() {
        return "# Note: If you modify this file, you must restart the XL Deploy server.";
    }

    protected String toComment(GlobalContext.Value value) {
        StringBuilder sb = new StringBuilder(value.description != null ? value.description.replace("\n", " ") : value.description);
        if (value instanceof GlobalContext.InheritedValue) {
            GlobalContext.InheritedValue inheritedValue = (GlobalContext.InheritedValue)value;
            sb.append(" (inherited from: ").append(inheritedValue.getSuperTypeProperty()).append(")");
        }
        return sb.toString();
    }

    protected static class Pair {
        protected final String key;
        protected final GlobalContext.Value value;

        public Pair(String key, GlobalContext.Value value) {
            this.key = key;
            this.value = value;
        }
    }
}

