package com.xebialabs.xlplatform.synthetic.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.xlplatform.synthetic.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

import static java.util.Collections.emptyList;

public class JsonTypeSpecification extends JsonSpecification implements TypeSpecification {

    private static final TypeName DEFAULT_BASE_TYPE = new TypeName("udm.BaseConfigurationItem");

    public JsonTypeSpecification(String name, JsonNode node) {
        super(name, node);
    }

    @Override
    public TypeName getTypeName() {
        return new TypeName(name);
    }

    @Override
    public Optional<Boolean> getVirtual() {
        return getOptionalBoolean("virtual");
    }

    @Override
    public List<PropertySpecification> getProperties() {

        // properties
        List<PropertySpecification> properties = new ArrayList<>(getProperties("properties"));

        // hidden-properties
        List<JsonPropertySpecification> hiddenProperties = getProperties("hidden-properties");
        hiddenProperties.forEach(p -> p.defaultHidden = true);
        properties.addAll(hiddenProperties);

        // input-properties
        List<JsonPropertySpecification> inputProperties = getProperties("input-properties");
        inputProperties.forEach(p -> p.defaultCategory = "input");
        properties.addAll(inputProperties);

        // output-properties
        List<JsonPropertySpecification> outputProperties = getProperties("output-properties");
        outputProperties.forEach(p -> p.defaultCategory = "output");
        properties.addAll(outputProperties);

        return properties;
    }

    @Override
    public Optional<Boolean> getVersioned() {
        return getOptionalBoolean("versioned");
    }

    @Override
    public TypeName getSuperType() {
        return getOptionalType("extends").orElse(DEFAULT_BASE_TYPE);
    }

    @Override
    public Optional<Boolean> getInspectable() {
        return getOptionalBoolean("inspectable");
    }

    @Override
    public Optional<String> getIcon() {
        return getOptionalString("icon");
    }

    @Override
    public Optional<String> getRoot() {
        return getOptionalString("root");
    }

    @Override
    public Optional<TypeName> getDeployedType() {
        return getOptionalType("deployable-type");
    }

    @Override
    public Optional<TypeName> getContainerType() {
        return getOptionalType("deployed-type");
    }

    @Override
    public List<MethodSpecification> getMethods() {
        List<MethodSpecification> methods = new ArrayList<>();
        if (!node.has("methods")) {
            return methods;
        }

        JsonNode methodNodes = node.get("methods");
        Iterator<String> iter = methodNodes.fieldNames();
        while (iter.hasNext()) {
            String methodName = iter.next();
            methods.add(new JsonMethodSpecification(methodName, methodNodes.get(methodName)));
        }

        return methods;
    }

    @Override
    public List<MethodSpecification> getControlTasks() {
        // XXX What is the difference between methods and control tasks?
        return getMethods();
    }

    // Deploy-specific functionality
    // XXX Currently not supported

    // TODO Implement
    @Override
    public List<String> getVerifications() {
        return emptyList();
    }

    // TODO Implement
    @Override
    public boolean hasGenerateDeployable() {
        return false;
    }

    // TODO Implement
    @Override
    public TypeSpecification getGenerateDeployable() {
        return null;
    }

    // TODO Implement
    @Override
    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        return null;
    }

    // TODO Implement
    @Override
    public Optional<CreatorSpecification> getCreator() {
        return Optional.empty();
    }
}
