package com.xebialabs.xlplatform.synthetic.yaml;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.TypeName;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JsonInputHintSpecification extends JsonSpecification implements InputHintSpecification {

    public JsonInputHintSpecification(JsonNode node) {
        super("input-hint", node);
    }

    @Override
    public List<InputHintValue> getValues() {
        List<InputHintValue> values = new ArrayList<>();
        if (!node.has("values")) {
            return values;
        }

        for (JsonNode valueNode : node.get("values")) {
            if (valueNode.isValueNode()) {
                values.add(new InputHintValue(valueNode.asText()));
            } else {
                String label = valueNode.fieldNames().next();
                values.add(new InputHintValue(valueNode.get(label).asText(), label));
            }
        }
        return values;
    }

    @Override
    public Optional<String> getPrompt() {
        return getOptionalString("prompt");
    }

    @Override
    public Optional<String> getCopyFromProperty() {
        return getOptionalString("copy-from-property");
    }

    @Override
    public Optional<TypeName> getReferencedType() {
        return getOptionalType("referenced-type");
    }

    @Override
    public Optional<String> getMethodRef() {
        return getOptionalString("method-ref");
    }

    @Override
    public Optional<Boolean> getDynamicLookup() {
        return getOptionalBoolean("dynamic-lookup");
    }
}
