package com.xebialabs.xlplatform.synthetic.xml;

import java.util.Iterator;
import java.util.Optional;

import com.xebialabs.xlplatform.synthetic.*;
import org.w3c.dom.Element;

import com.xebialabs.deployit.plugin.api.udm.Metadata;

public class XmlTypeSpecification extends XmlBaseTypeSpecification implements TypeSpecification {

    public XmlTypeSpecification(Element element) {
        super(element);
    }

    @Override
    public boolean hasGenerateDeployable() {
        return XmlUtils.childByName(element, "generate-deployable"::equals).hasNext();
    }

    @Override
    public TypeSpecification getGenerateDeployable() {
        Iterator<Element> generatedTypes = XmlUtils.childByName(element, "generate-deployable"::equals);
        if (generatedTypes.hasNext()) {
            return new XmlTypeSpecification(generatedTypes.next());
        }
        return null;
    }

    @Override
    public TypeName getSuperType() {
        return XmlUtils.getRequiredTypeAttribute(element, "extends");
    }

    @Override
    public Optional<String> getLabel() {
        return XmlUtils.getOptionalString(element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return XmlUtils.getOptionalString(element, "description");
    }

    @Override
    public Optional<Boolean> getInspectable() {
        return XmlUtils.getOptionalBoolean(element, "inspectable");
    }

    @Override
    public Optional<String> getIcon() {
        Iterator<Element> generateElements = XmlUtils.childByName(element, "icon"::equals);
        if (generateElements.hasNext()) {
            Element iconElement = generateElements.next();
            return Optional.ofNullable(iconElement.getTextContent());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getRoot() {
        return XmlUtils.getOptionalString(element, "root").flatMap(rootName -> {
            for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                if (rootName.equalsIgnoreCase(configurationItemRoot.getRootNodeName())) {
                    if (configurationItemRoot == Metadata.ConfigurationItemRoot.BY_ROOT_NAME) {
                        return Optional.of(XmlUtils.getRequiredStringAttribute(element, "rootName"));
                    }
                    return Optional.of(configurationItemRoot.getRootNodeName());
                }
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<TypeName> getDeployedType() {
        return XmlUtils.getOptionalType(element, "deployable-type");
    }

    @Override
    public Optional<TypeName> getContainerType() {
        return XmlUtils.getOptionalType(element, "container-type");
    }

    @Override
    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        Iterator<Element> generateElements = XmlUtils.childByName(element, "generate-deployable"::equals);
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            return new DefaultGeneratedDeployableSpecification(
                    XmlUtils.getRequiredTypeAttribute(generateDeployable, "type"),
                    XmlUtils.getRequiredTypeAttribute(generateDeployable, "extends"),
                    XmlUtils.getOptionalBooleanAttribute(generateDeployable, "copy-default-values", false),
                    XmlUtils.getOptionalBooleanAttribute(generateDeployable, "virtual", false),
                    XmlUtils.getOptionalStringAttribute(generateDeployable, "description", "Description unavailable")
            );
        }
        return null;
    }

    @Override
    public Optional<CreatorSpecification> getCreator() {
        Iterator<Element> creatorElements = XmlUtils.childByName(element, "creator"::equals);
        if (creatorElements.hasNext()) {
            Element creatorElement = creatorElements.next();
            CreatorSpecification creatorSpecification = new XmlCreatorSpecification(creatorElement);
            return Optional.of(creatorSpecification);
        }
        return Optional.empty();
    }
}
