package com.xebialabs.xlplatform.synthetic.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import com.xebialabs.xlplatform.synthetic.*;
import org.w3c.dom.Element;

public class XmlBaseTypeSpecification extends XmlElement implements BaseTypeSpecification {

    public XmlBaseTypeSpecification(Element element) {
        super(element);
    }

    @Override
    public TypeName getTypeName() {
        return XmlUtils.getRequiredTypeAttribute(element, "type");
    }

    @Override
    public Optional<Boolean> getVirtual() {
        return XmlUtils.getOptionalBoolean(element, "virtual");
    }

    @Override
    public List<PropertySpecification> getProperties() {
        List<PropertySpecification> properties = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "property"::equals), child -> {
            XmlUtils.getRequiredStringAttribute(child, "name");
            properties.add(new XmlPropertySpecification(child));
        });
        return properties;
    }

    @Override
    public List<MethodSpecification> getMethods() {
        List<MethodSpecification> methods = new ArrayList<>();
        XmlUtils.childByName(element, "method"::equals).forEachRemaining(
            method -> methods.add(new XmlMethodSpecification(method)));

        return methods;
    }

    @Override
    public Optional<Boolean> getVersioned() {
        return XmlUtils.getOptionalBoolean(element, "versioned");
    }

    @Override
    public List<ValidationRuleSpecification> getValidationRules() {
        List<ValidationRuleSpecification> validators = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "rule"::equals),
            element -> validators.add(new XmlValidationRuleSpecification(element)));
        return validators;
    }

    @Override
    public List<String> getVerifications() {
        List<String> verifications = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "verification"::equals),
                element -> verifications.add(element.getAttribute("type")));
        return verifications;
    }

    @Override
    public List<MethodSpecification> getControlTasks() {
        List<MethodSpecification> methods = new ArrayList<>();
        XmlUtils.forEach(XmlUtils.childByName(element, "method"::equals), child ->
            methods.add(new XmlMethodSpecification(child))
        );
        return methods;
    }
}
