package com.xebialabs.xlplatform.synthetic.xml;

import java.util.Iterator;
import java.util.Optional;
import org.w3c.dom.Element;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlplatform.synthetic.CreatorSpecification;
import com.xebialabs.xlplatform.synthetic.DefaultGeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;

public class XmlTypeSpecification extends XmlBaseTypeSpecification implements TypeSpecification {

    public XmlTypeSpecification(IDescriptorRegistry descriptorRegistry, Element element) {
        super(descriptorRegistry, element);
    }

    @Override
    public boolean hasGenerateDeployable() {
        return childByName(element, "generate-deployable"::equals).hasNext();
    }

    @Override
    public TypeSpecification getGenerateDeployable() {
        Iterator<Element> generatedTypes = childByName(element, "generate-deployable"::equals);
        if (generatedTypes.hasNext()) {
            return new XmlTypeSpecification(descriptorRegistry, generatedTypes.next());
        }
        return null;
    }

    @Override
    public Type getSuperType() {
        return getRequiredTypeAttribute(element, "extends");
    }

    @Override
    public Optional<String> getLabel() {
        return getOptionalString(element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return getOptionalString(element, "description");
    }

    @Override
    public Optional<Boolean> getInspectable() {
        return getOptionalBoolean(element, "inspectable");
    }

    @Override
    public Optional<String> getIcon() {
        Iterator<Element> generateElements = childByName(element, "icon"::equals);
        if (generateElements.hasNext()) {
            Element iconElement = generateElements.next();
            return Optional.ofNullable(iconElement.getTextContent());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> getRoot() {
        return getOptionalString(element, "root").flatMap(rootName -> {
            for (Metadata.ConfigurationItemRoot configurationItemRoot : Metadata.ConfigurationItemRoot.values()) {
                if (rootName.equalsIgnoreCase(configurationItemRoot.getRootNodeName())) {
                    if (configurationItemRoot == Metadata.ConfigurationItemRoot.BY_ROOT_NAME) {
                        return Optional.of(getRequiredStringAttribute(element, "rootName"));
                    }
                    return Optional.of(configurationItemRoot.getRootNodeName());
                }
            }
            return Optional.empty();
        });
    }

    @Override
    public Optional<Type> getDeployedType() {
        return getOptionalType(element, "deployable-type");
    }

    @Override
    public Optional<Type> getContainerType() {
        return getOptionalType(element, "container-type");
    }

    @Override
    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        Iterator<Element> generateElements = childByName(element, "generate-deployable"::equals);
        if (generateElements.hasNext()) {
            Element generateDeployable = generateElements.next();
            return new DefaultGeneratedDeployableSpecification(
                    getRequiredTypeAttribute(generateDeployable, "type"),
                    getRequiredTypeAttribute(generateDeployable, "extends"),
                    getOptionalBooleanAttribute(generateDeployable, "copy-default-values", false),
                    getOptionalBooleanAttribute(generateDeployable, "virtual", false),
                    getOptionalStringAttribute(generateDeployable, "description", "Description unavailable")
            );
        }
        return null;
    }

    @Override
    public Optional<CreatorSpecification> getCreator() {
        Iterator<Element> creatorElements = childByName(element, "creator"::equals);
        if (creatorElements.hasNext()) {
            Element creatorElement = creatorElements.next();
            CreatorSpecification creatorSpecification = new XmlCreatorSpecification(descriptorRegistry, creatorElement);
            return Optional.of(creatorSpecification);
        }
        return Optional.empty();
    }
}
