package com.xebialabs.xlplatform.synthetic.xml;

import java.util.*;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;

public class XmlMethodSpecification extends XmlElement implements MethodSpecification {

    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = new HashSet<>(Arrays.asList("name", "label", "description", "parameters-type"));

    public XmlMethodSpecification(IDescriptorRegistry descriptorRegistry, Element element) {
        super(descriptorRegistry, element);
    }

    @Override
    public String getName() {
        return getRequiredStringAttribute(element, "name");
    }

    @Override
    public List<PropertySpecification> getParameters() {
        List<PropertySpecification> parameters = new ArrayList<>();
        if (!childByName(element, "parameters"::equals).hasNext()) {
            return parameters;
        }

        Element parametersElement = childByName(element, "parameters"::equals).next();
        childByName(parametersElement, "parameter"::equals)
                .forEachRemaining(parameter -> parameters.add(new XmlPropertySpecification(descriptorRegistry, parameter)));

        return parameters;
    }

    @Override
    public Optional<String> getLabel() {
        return getOptionalString(element, "label");
    }

    @Override
    public Optional<String> getDescription() {
        return getOptionalString(element, "description");
    }

    @Override
    public Optional<String> getDelegate() {
        return getOptionalString(element, "delegate");
    }

    @Override
    public Type getParameterType() {
        return getOptionalTypeAttribute(element, "parameters-type");
    }

    @Override
    public Map<String, String> getAttributes() {
        return readAttributes(element);
    }

    private static Map<String, String> readAttributes(final Element element) {
        Map<String, String> map = new HashMap<>();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); i++) {
            Attr item = (Attr) xmlAttrs.item(i);
            if (!RESERVED_ATTRIBUTE_NAMES.contains(item.getName())) {
                map.put(item.getName(), item.getValue());
            }
        }

        return map;
    }
}
