package com.xebialabs.deployit.booter.local;

import java.util.List;
import java.util.Optional;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.LazyConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.synthetic.InputHintSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;

import static com.xebialabs.deployit.booter.local.utils.Strings.deCamelize;
import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.CI;
import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.ENUM;
import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.LIST_OF_CI;
import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.SET_OF_CI;
import static com.xebialabs.deployit.plugin.api.reflect.PropertyKind.STRING;
import static com.xebialabs.xlplatform.utils.ClassLoaderUtils.classByName;

public class SyntheticLocalPropertyDescriptor extends LocalPropertyDescriptor {

    public SyntheticLocalPropertyDescriptor(LocalDescriptor descriptor, PropertySpecification property) {
        String name = property.getName();
        setName(name);
        setDeclaringDescriptor(descriptor);
        initSynthetic(property);
    }

    private void initSynthetic(PropertySpecification property) {
        PropertyKind pk = PropertyKind.valueOf(property.getKind().orElse(STRING.name()).toUpperCase());
        if (pk == PropertyKind.BOOLEAN) {
            setPrimitiveKind(pk);
        } else {
            setKind(pk);
        }
        setCategory(property.getCategory().orElse("Common"));
        setLabel(property.getLabel().orElse(deCamelize(getName())));
        setDescription(property.getDescription().orElse(getLabel()));
        setRequired(property.getRequired().orElse(true));
        reInitializeRequired();
        setPassword(property.getPassword().orElse(false));
        setAsContainment(property.getAsContainment().orElse(false));
        setNested(property.getNested().orElse(false));
        setSize(Property.Size.valueOf(property.getSize().orElse(Property.Size.DEFAULT.name()).toUpperCase()));
        String defaultValueAttr = property.getDefault().orElse(null);
        setHidden(property.getHidden().orElse(false));
        setInspectionProperty(property.getInspectionProperty().orElse(false));
        setAliases(property.getAliases());
        setTransient(isHidden() || property.getTransient().orElse(false));
        setCandidateValuesFilter(property.getCandidateValuesFilter().orElse(null));
        setReadonly(property.getReadOnly().orElse(false));

        PropertyKind kind = getKind();
        String propertyName = "property " + getName() + " of kind " + getKind();

        if (getKind() == ENUM) {
            Optional<String> enumClassName = property.getEnumClass();
            if (enumClassName.isPresent()) {
                try {
                    Class<?> enumClass = classByName(enumClassName.get());
                    setEnumClass(enumClass);
                    if (!enumClass.isEnum()) {
                        throw new IllegalArgumentException("enum-class supplied for " + propertyName + " is not an enum: "
                                + enumClassName);
                    }
                    List<String> enumValues = property.getEnumValues();
                    initEnumValues(enumClass, enumValues);
                } catch (ClassNotFoundException exc) {
                    throw new IllegalArgumentException("Unknown enum-class supplied for " + propertyName + ": " + enumClassName,
                            exc);
                }
            } else {
                List<String> enumValues = property.getEnumValues();
                if (enumValues.isEmpty()) {
                    throw new IllegalArgumentException("Could not find 'enum-class' attribute or 'enum-values' element defined on " + propertyName);
                }
                setEnumValues(enumValues);
            }
        }

        if (kind == CI || kind == SET_OF_CI || kind == LIST_OF_CI) {
            Optional<String> referencedType = property.getReferencedType();
            if (referencedType.isEmpty()) {
                throw new IllegalArgumentException("Attribute referenced-type not provided input-hint for " + propertyName);
            }
            setReferencedType(typeOf(referencedType.get()));
        }

        initSyntheticValidationRules(property);
        addDefaultValidationRules();
        initSyntheticInputHints(property, kind);
        registerDefault(defaultValueAttr);
    }

    private Type typeOf(String referencedType) {
        return descriptorRegistry().lookupType(referencedType);
    }

    private void initSyntheticInputHints(PropertySpecification property, PropertyKind propertyKind) {
        for (InputHintSpecification inputHintSpec : property.getInputHints()) {

            InputHint inputHint = new InputHint();
            inputHint.setKind(propertyKind);
            inputHint.setValues(inputHintSpec.getValues());
            inputHintSpec.getValidationRules().forEach(rule ->
                inputHint.getValidationRules().add(ValidationRuleConverter.makeRule(rule, this)));
            inputHint.setPrompt(inputHintSpec.getPrompt().orElse(null));
            inputHint.setCopyFromProperty(inputHintSpec.getCopyFromProperty().orElse(null));
            inputHint.setRequired(isRequired());
            inputHint.setReferencedType(inputHintSpec.getReferencedType().orElse(null));
            inputHint.setMethodRef(inputHintSpec.getMethodRef().orElse(null));
            inputHint.setDynamicLookup(inputHintSpec.getDynamicLookup().orElse(true));

            setInputHint(inputHint);
        }
    }

    private void initSyntheticValidationRules(PropertySpecification property) {
        property.getValidationRules().forEach(rule ->
            validationRules.add(ValidationRuleConverter.makeRule(rule, this)));
    }

    @Override
    public Object get(ConfigurationItem item) {
        if (item instanceof LazyConfigurationItem) {
            LazyConfigurationItem lazyItem = (LazyConfigurationItem) item;
            if (!lazyItem.isInitialized()) {
                lazyItem.initialize();
            }
        }
        return getDeclaringDescriptor().getSyntheticPropertyValue(item, getName());
    }

    @Override
    public final void set(ConfigurationItem item, Object value) {
        if (item instanceof LazyConfigurationItem) {
            LazyConfigurationItem lazyItem = (LazyConfigurationItem) item;
            if (!lazyItem.isInitialized()) {
                lazyItem.initialize();
            }
        }
        super.set(item, value);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        // TODO think if we have to initialize CI before we set a property
        getDeclaringDescriptor().setSyntheticPropertyValue(item, getName(), value);
    }

    protected IDescriptorRegistry descriptorRegistry() {
        return getDeclaringDescriptor().descriptorRegistry();
    }
}
