/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlOperations;
import com.xebialabs.xlplatform.synthetic.xml.XmlTypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlTypeSpecification;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SyntheticXmlDocument
implements XmlOperations {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticXmlDocument.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticXmlDocument.class);
    private IDescriptorRegistry descriptorRegistry;
    private final List<TypeSpecification> types = new ArrayList<TypeSpecification>();
    private final List<TypeModificationSpecification> typeModifications = new ArrayList<TypeModificationSpecification>();

    private SyntheticXmlDocument(IDescriptorRegistry descriptorRegistry, Element docElement) {
        this.descriptorRegistry = descriptorRegistry;
        this.childByName(docElement, "type"::equals).forEachRemaining(element -> this.types.add(new XmlTypeSpecification(descriptorRegistry, (Element)element)));
        this.childByName(docElement, "type-modification"::equals).forEachRemaining(element -> this.typeModifications.add(new XmlTypeModificationSpecification(descriptorRegistry, (Element)element)));
    }

    public static SyntheticXmlDocument read(IDescriptorRegistry descriptorRegistry, URL syntheticXML) throws IOException {
        String syntheticString = IOUtils.toString((URL)syntheticXML, (Charset)StandardCharsets.UTF_8);
        Element docElement = SyntheticXmlDocument.readSyntheticDocument(syntheticString).getDocumentElement();
        return new SyntheticXmlDocument(descriptorRegistry, docElement);
    }

    public static SyntheticXmlDocument read(IDescriptorRegistry descriptorRegistry, String syntheticXML) throws IOException {
        Element docElement = SyntheticXmlDocument.readSyntheticDocument(syntheticXML).getDocumentElement();
        return new SyntheticXmlDocument(descriptorRegistry, docElement);
    }

    public List<TypeSpecification> getTypes() {
        return this.types;
    }

    public List<TypeModificationSpecification> getTypeModifications() {
        return this.typeModifications;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema syntheticSchema = schemaFactory.newSchema(ClassLoaderUtils$.MODULE$.classLoader().getResource("synthetic.xsd"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setSchema(syntheticSchema);
            SyntheticXmlDocument.setFeatureQuietly(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            SyntheticXmlDocument.setFeatureQuietly(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
            SyntheticXmlDocument.setFeatureQuietly(documentBuilderFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SyntheticXmlDocument.setFeatureQuietly(documentBuilderFactory, "http://xml.org/sax/features/external-general-entities", false);
            SyntheticXmlDocument.setFeatureQuietly(documentBuilderFactory, "http://xml.org/sax/features/external-parameter-entities", false);
            return documentBuilderFactory;
        }
        catch (SAXException exc) {
            throw new IllegalStateException("Cannot read schema synthetic.xsd", exc);
        }
    }

    private static void setFeatureQuietly(DocumentBuilderFactory factory, String name, boolean value) {
        try {
            factory.setFeature(name, value);
        }
        catch (Exception ex) {
            logger.warn(String.format("Cannot set feature [%s] for [%s]", name, factory.getClass().getName()), (Throwable)ex);
        }
    }

    private static Document readSyntheticDocument(final String syntheticXML) throws IOException {
        try {
            final boolean[] validationErrorsFound = new boolean[1];
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exc) {
                    logger.warn("Warning while parsing " + syntheticXML, (Throwable)exc);
                }

                @Override
                public void error(SAXParseException exc) {
                    logger.error("Error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) {
                    logger.error("Fatal error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(IOUtils.toInputStream((String)syntheticXML, (Charset)StandardCharsets.UTF_8));
            if (validationErrorsFound[0]) {
                throw new IllegalArgumentException("One or more errors were found while parsing " + syntheticXML);
            }
            return doc;
        }
        catch (RuntimeException | ParserConfigurationException | SAXException exc) {
            throw new IllegalStateException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
    }

    @Override
    public IDescriptorRegistry descriptorRegistry() {
        return this.descriptorRegistry;
    }
}

