/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.ClassBasedLocalDescriptor;
import com.xebialabs.deployit.booter.local.GenerateDeployableTypeDefinition;
import com.xebialabs.deployit.booter.local.GeneratedParameterTypeDefinition;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticBasedTypeDefinition;
import com.xebialabs.deployit.booter.local.TypeDefinition;
import com.xebialabs.deployit.booter.local.TypeDefinitionsRegistry;
import com.xebialabs.deployit.booter.local.utils.CheckUtils;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.synthetic.BaseTypeSpecification;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = new HashMap<Type, TypeDefinition>();
    private IDescriptorRegistry registry;
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    public TypeDefinitions(IDescriptorRegistry registry, Collection<TypeDefinition> existingTypeDefinitions) {
        this.registry = registry;
        existingTypeDefinitions.forEach(this::addTypeDef);
        TypeDefinitionsRegistry.register(registry.getId(), this);
    }

    public TypeDefinitions(IDescriptorRegistry registry) {
        this(registry, Collections.emptyList());
    }

    public void addTypeDef(TypeDefinition typeDef) {
        CheckUtils.checkState(!this.typeDefs.containsKey(typeDef.type), "Trying to register duplicate definition for type [%s]. Existing: [%s], duplicate: [%s]", typeDef.type, this.typeDefs.get(typeDef.type), typeDef);
        this.typeDefs.put(typeDef.type, typeDef);
    }

    public Collection<TypeDefinition> getDefinitions() {
        return new ArrayList<TypeDefinition>(this.typeDefs.values());
    }

    private TypeDefinition getDefinition(Type type) {
        return CheckUtils.checkNotNull(this.typeDefs.get(type), "Could not find a type definition associated with type [%s]", type);
    }

    public void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(this.registry, clazz);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void defineType(TypeSpecification typeSpec) {
        this.addTypeDef(new SyntheticBasedTypeDefinition(typeSpec));
        if (typeSpec.hasGenerateDeployable()) {
            this.addTypeDef(new GenerateDeployableTypeDefinition(typeSpec.getType(), typeSpec.getGenerateDeployable()));
        }
        this.findAllGeneratedParameterTypes(typeSpec);
    }

    public void redefineType(TypeSpecification typeSpec) {
        SyntheticBasedTypeDefinition typeDef = new SyntheticBasedTypeDefinition(typeSpec);
        this.typeDefs.put(typeDef.type, typeDef);
        if (typeSpec.hasGenerateDeployable()) {
            GenerateDeployableTypeDefinition generatedTypeDef = new GenerateDeployableTypeDefinition(typeSpec.getType(), typeSpec.getGenerateDeployable());
            this.typeDefs.put(generatedTypeDef.type, generatedTypeDef);
        }
        this.findAllGeneratedParameterTypes(typeSpec);
    }

    void modifyType(TypeModificationSpecification typeModification) {
        CheckUtils.checkState(this.typeDefs.containsKey(typeModification.getType()), "Detected type-modification for non-existing type [%s]", typeModification.getType());
        this.typeDefs.get(typeModification.getType()).addTypeModification(typeModification);
        this.findAllGeneratedParameterTypes(typeModification);
        logger.debug("Found: {}", (Object)typeModification);
    }

    private void findAllGeneratedParameterTypes(BaseTypeSpecification type) {
        for (MethodSpecification method : type.getMethods()) {
            if (method.getParameters().isEmpty()) continue;
            this.defineGeneratedParameterType(method, type);
        }
    }

    void defineGeneratedParameterType(MethodSpecification methodDef, BaseTypeSpecification baseType) {
        GeneratedParameterTypeDefinition typeDef = new GeneratedParameterTypeDefinition(this.registry, baseType, methodDef);
        this.addTypeDef(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    public void registerTypes() {
        this.getDefinitions().forEach(definition -> this.registerAsSubtype((TypeDefinition)definition, definition.type));
        this.getDefinitions().forEach(this::register);
    }

    private void registerAsSubtype(TypeDefinition definition, Type type) {
        if (definition.superType != null) {
            this.registry.registerSubtype(definition.superType, type);
            this.registerAsSubtype(this.getDefinition(definition.superType), type);
        }
        for (Type anInterface : definition.getInterfaces()) {
            this.registry.registerSubtype(anInterface, type);
        }
    }

    private void register(TypeDefinition definition) {
        if (this.registry._exists(definition.type)) {
            return;
        }
        if (definition.superType != null && !this.registry._exists(definition.superType)) {
            this.register(this.getDefinition(definition.superType));
        }
        for (Type anInterface : definition.getInterfaces()) {
            if (this.registry._exists(anInterface)) continue;
            this.register(this.getDefinition(anInterface));
        }
        if (definition.getOwner() != null && !this.registry._exists(definition.getOwner())) {
            this.register(this.getDefinition(definition.getOwner()));
        }
        LocalDescriptor descriptor = definition.createDescriptor();
        this.registry.register((Descriptor)descriptor);
        definition.applyTypeModifications(descriptor);
    }

    private static boolean isClassACi(Class<?> clazz) {
        return clazz != null && ConfigurationItem.class.isAssignableFrom(clazz);
    }

    class ClassBasedTypeDefinition
    extends TypeDefinition {
        private Class<? extends ConfigurationItem> clazz;
        private IDescriptorRegistry registry;

        public ClassBasedTypeDefinition(IDescriptorRegistry registry, Class<? extends ConfigurationItem> ci) {
            this.registry = registry;
            this.type = this.type(ci);
            this.superType = this.type(ci.getSuperclass());
            this.interfaces = ReflectionUtils.getAllInterfaces(ci).stream().map(this::type).filter(Objects::nonNull).collect(Collectors.toList());
            this.clazz = ci;
        }

        @Override
        protected LocalDescriptor createDescriptor() {
            return new ClassBasedLocalDescriptor(this.registry, this.clazz);
        }

        private Type type(Class<?> clazz) {
            if (TypeDefinitions.isClassACi(clazz)) {
                return this.registry.lookupType(clazz);
            }
            return null;
        }
    }
}

