package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlplatform.synthetic.GeneratedDeployableSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;

class SyntheticLocalDescriptor extends LocalDescriptor {

    private GeneratedDeployableSpecification generatedDeployableSpec;

    public SyntheticLocalDescriptor(TypeSpecification typeSpec) {
        Type type = typeSpec.getType();
        setType(type);
        initSynthetic(typeSpec);
        initHierarchy();
        resolveIcon();
    }

    private void initSynthetic(TypeSpecification typeSpec) {
        Type superType = typeSpec.getSuperType();
        addSuperClass(superType);
        setLabel(typeSpec.getLabel().orElse(toLabel(getType())));
        setDescription(typeSpec.getDescription().orElse("Description unavailable"));
        setVirtual(typeSpec.getVirtual().orElse(false));
        setVersioned(typeSpec.getVersioned().orElse(superType.getDescriptor().isVersioned()));
        setInspectable(typeSpec.getInspectable().orElse(false));
        typeSpec.getIcon().ifPresent(icon -> {
            this.setIcon(icon);
            this.setOwnIcon(true);
        });
        setRootName(typeSpec.getRoot());
        typeSpec.getContainerType().ifPresent(this::setContainerType);
        typeSpec.getDeployedType().ifPresent(this::setDeployableType);
        validators.addAll(createValidators(typeSpec.getValidators(), getType()));
        verifications.addAll(createVerifications(typeSpec.getVerifications(), getType()));
        typeSpec.getControlTasks().forEach(this::validateAndAddControlTask);
        typeSpec.getCreator().ifPresent(spec -> setCreator(LocalCreatorDescriptor.from(this, spec.getDelegate(), spec.getAttributes())));
        getPropertyDescriptors(typeSpec.getProperties()).forEach(this::overrideOrAddPropertyDescriptor);
        generatedDeployableSpec = typeSpec.getGeneratedDeployableDescription();
    }

    public GeneratedDeployableSpecification getGeneratedDeployableDescription() {
        return generatedDeployableSpec;
    }

    @Override
    protected IDescriptorRegistry descriptorRegistry() {
        final DescriptorRegistryId typeSource = getType().getTypeSource();
        return DescriptorRegistry.getDescriptorRegistry(typeSource);
    }
}
