package com.xebialabs.deployit.booter.local.validation

import com.xebialabs.deployit.booter.local.Converter
import com.xebialabs.deployit.plugin.api.validation.{ValidationContext, Validator}
import grizzled.slf4j.Logging

import scala.util.Try

class ConvertingValidationRule[T](val delegate: Validator[T], val converter: Converter) extends Validator[String] with Logging {

  def convert(value: String): T = converter.convert(value).asInstanceOf[T]

  override def validate(value: String, context: ValidationContext): Unit = {
    Try(convert(value)).map(a => delegate.validate(a, context)).recover {
      case e: Exception => logger.debug(s"Validation ${delegate.getClass.getName} on property '$value' ignored because of incompatible conversion", e)
    }
  }
}