package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;

import static com.xebialabs.deployit.booter.local.DescriptorVerification.PLACEHOLDERS_FIELD;

class GenerateDeployableLocalDescriptor extends LocalDescriptor {

    public GenerateDeployableLocalDescriptor(SyntheticLocalDescriptor deployedDescriptor) {
        GeneratedDeployableDescription generatedDeployableDescription = deployedDescriptor.getGeneratedDeployableDescription();
        setType(generatedDeployableDescription.getType());
        addSuperClass(generatedDeployableDescription.getSuperType());
        initDescription(generatedDeployableDescription, deployedDescriptor.getDescription());
        setVirtual(generatedDeployableDescription.isVirtual());
        initProperties(deployedDescriptor, generatedDeployableDescription.isInheritDefaultValues());
        initHierarchy();
        resolveIcon();
    }

    private void initDescription(GeneratedDeployableDescription generatedDeployableDescription, String deployedDescription) {
        String description = generatedDeployableDescription.getDescription();
        if (description == null || description.equals("Description unavailable")) {
            setDescription(deployedDescription + " (deployable)");
        } else {
            setDescription(description);
        }

    }

    private void initProperties(Descriptor descriptor, boolean withDefaults) {
        for (PropertyDescriptor deployedPropertyDescriptor : descriptor.getPropertyDescriptors()) {
            final PropertyKind kind = deployedPropertyDescriptor.getKind();
            boolean isReferenceField = kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI;
            if (deployedPropertyDescriptor.isDeployedSpecific() ||
                    isReferenceField ||
                    deployedPropertyDescriptor.isHidden() ||
                    PLACEHOLDERS_FIELD.equals(deployedPropertyDescriptor.getName())) {
                continue;
            }

            LocalPropertyDescriptor generatedDeployablePropertyDescriptor = new GeneratedDeployablePropertyDescriptor(this, deployedPropertyDescriptor);
            if (withDefaults) {
                GlobalContext.register(generatedDeployablePropertyDescriptor, GlobalContext.lookup(deployedPropertyDescriptor));
            }
            addPropertyDescriptor(generatedDeployablePropertyDescriptor);
        }
    }
}
