/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class SyntheticLocalPropertyDescriptor
extends LocalPropertyDescriptor {
    public SyntheticLocalPropertyDescriptor(LocalDescriptor descriptor, Element propertyElement) {
        String name = XmlUtils.getRequiredStringAttribute(propertyElement, "name");
        this.setName(name);
        this.setDeclaringDescriptor(descriptor);
        this.initSynthetic(propertyElement);
    }

    private void initSynthetic(Element propertyElement) {
        PropertyKind pk = PropertyKind.valueOf((String)XmlUtils.getOptionalStringAttribute(propertyElement, "kind", PropertyKind.STRING.name()).toUpperCase());
        if (pk == PropertyKind.BOOLEAN) {
            this.setPrimitiveKind(pk);
        } else {
            this.setKind(pk);
        }
        this.setCategory(XmlUtils.getOptionalStringAttribute(propertyElement, "category", "Common"));
        this.setLabel(XmlUtils.getOptionalStringAttribute(propertyElement, "label", Strings.deCamelize(this.getName())));
        this.setDescription(XmlUtils.getOptionalStringAttribute(propertyElement, "description", this.getLabel()));
        this.setRequired(XmlUtils.getOptionalBooleanAttribute(propertyElement, "required", true));
        this.reInitializeRequired();
        this.setPassword(XmlUtils.getOptionalBooleanAttribute(propertyElement, "password", false));
        this.setAsContainment(XmlUtils.getOptionalBooleanAttribute(propertyElement, "as-containment", false));
        this.setSize(Property.Size.valueOf((String)XmlUtils.getOptionalStringAttribute(propertyElement, "size", Property.Size.DEFAULT.name()).toUpperCase()));
        String defaultValueAttr = XmlUtils.getOptionalStringAttribute(propertyElement, "default", null);
        this.setHidden(XmlUtils.getOptionalBooleanAttribute(propertyElement, "hidden", false));
        this.setInspectionProperty(XmlUtils.getOptionalBooleanAttribute(propertyElement, "inspectionProperty", false));
        this.setAliases(new HashSet<String>(Strings.split(XmlUtils.getOptionalStringAttribute(propertyElement, "aliases", ""), ",")));
        this.setTransient(this.isHidden() || XmlUtils.getOptionalBooleanAttribute(propertyElement, "transient", false));
        this.setCandidateValuesFilter(XmlUtils.getOptionalStringAttribute(propertyElement, "candidate-values-filter", null));
        PropertyKind kind = this.getKind();
        if (this.getKind() == PropertyKind.ENUM) {
            if (propertyElement.hasAttribute("enum-class")) {
                String enumClassAttributeValue = XmlUtils.getRequiredStringAttribute(propertyElement, "enum-class", "for property " + this.getName() + " of kind " + this.getKind());
                try {
                    Class enumClass = ClassLoaderUtils.classByName((String)enumClassAttributeValue);
                    this.setEnumClass(enumClass);
                    if (!enumClass.isEnum()) {
                        throw new IllegalArgumentException("enum-class supplied for property " + this.getName() + " of kind " + this.getKind() + " is not an enum: " + enumClassAttributeValue);
                    }
                    this.initEnumValues(enumClass);
                }
                catch (ClassNotFoundException exc) {
                    throw new IllegalArgumentException("Unknown enum-class supplied for property " + this.getName() + " of kind " + this.getKind() + ": " + enumClassAttributeValue, exc);
                }
            } else {
                NodeList evs = propertyElement.getElementsByTagName("enum-values");
                ArrayList<String> enumValues = new ArrayList<String>();
                if (evs.getLength() != 1) {
                    throw new IllegalArgumentException("Could not find 'enum-class' attribute or 'enum-values' element defined on property " + this.getName() + " of kind " + this.getKind());
                }
                XmlUtils.forEach(XmlUtils.childByName((Element)evs.item(0), "value"::equals), element -> enumValues.add(element.getTextContent()));
                this.setEnumValues(enumValues);
            }
        }
        if (kind == PropertyKind.CI || kind == PropertyKind.SET_OF_CI || kind == PropertyKind.LIST_OF_CI) {
            this.setReferencedType(Type.valueOf((String)XmlUtils.getRequiredStringAttribute(propertyElement, "referenced-type", "for property " + this.getName() + " of kind " + this.getKind())));
        }
        this.initSyntheticValidationRules(propertyElement);
        this.addDefaultValidationRules();
        this.initSyntheticInputHints(propertyElement, kind);
        this.registerDefault(defaultValueAttr);
    }

    private void initSyntheticInputHints(Element propertyElement, PropertyKind propertyKind) {
        XmlUtils.forEach(XmlUtils.childByName(propertyElement, "input-hint"::equals), inputHintElement -> {
            InputHint inputHint = new InputHint();
            inputHint.setKind(propertyKind);
            XmlUtils.forEach(XmlUtils.childByName(inputHintElement, "values"::equals), valuesElement -> {
                ArrayList inputHintValues = new ArrayList();
                XmlUtils.forEach(XmlUtils.childByName(valuesElement, "value"::equals), valueElement -> {
                    String value = valueElement.getTextContent();
                    String label = XmlUtils.getOptionalStringAttribute(valueElement, "label", value);
                    inputHintValues.add(InputHintValue.inputHintValue((String)value, (String)label));
                });
                inputHint.setValues(inputHintValues);
            });
            XmlUtils.forEach(XmlUtils.childByName(inputHintElement, "rule"::equals), rule -> inputHint.getValidationRules().add(ValidationRuleConverter.makeRule(rule, (LocalPropertyDescriptor)this)));
            XmlUtils.forEach(XmlUtils.childByName(inputHintElement, "prompt"::equals), prompt -> inputHint.setPrompt(prompt.getFirstChild().getTextContent()));
            XmlUtils.forEach(XmlUtils.childByName(inputHintElement, "copy-from-property"::equals), copyFromProperty -> inputHint.setCopyFromProperty(copyFromProperty.getFirstChild().getTextContent()));
            inputHint.setRequired(this.isRequired());
            this.setInputHint(inputHint);
        });
    }

    private void initSyntheticValidationRules(Element propertyElement) {
        XmlUtils.forEach(XmlUtils.childByName(propertyElement, "rule"::equals), element -> this.validationRules.add(ValidationRuleConverter.makeRule(element, (LocalPropertyDescriptor)this)));
    }

    public Object get(ConfigurationItem item) {
        return this.getDeclaringDescriptor().getSyntheticPropertyValue(item, this.getName());
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.getDeclaringDescriptor().setSyntheticPropertyValue(item, this.getName(), value);
    }
}

