/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.TypeHint;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

class GeneratedDeployablePropertyDescriptor
extends LocalPropertyDescriptor {
    public GeneratedDeployablePropertyDescriptor(LocalDescriptor descriptor, PropertyDescriptor deployedPropertyDescriptor) {
        this.setName(deployedPropertyDescriptor.getName());
        this.setDeclaringDescriptor(descriptor);
        this.initMetadataFromDescriptor(deployedPropertyDescriptor);
    }

    private void initMetadataFromDescriptor(PropertyDescriptor propertyDescriptor) {
        this.setKind(propertyDescriptor.getKind().isSimple() ? PropertyKind.STRING : propertyDescriptor.getKind());
        this.setCategory(propertyDescriptor.getCategory());
        this.setLabel(propertyDescriptor.getLabel());
        this.setRequired(false);
        this.setPassword(propertyDescriptor.isPassword());
        this.setSize(propertyDescriptor.getSize());
        this.initDescription(propertyDescriptor);
        this.initTypeHint(propertyDescriptor);
    }

    private void initDescription(PropertyDescriptor propertyDescriptor) {
        String description = String.format("%s (%s)", propertyDescriptor.getDescription(), propertyDescriptor.getKind().name().toLowerCase());
        if (propertyDescriptor.getKind() == PropertyKind.ENUM) {
            description = description + String.format(" values(%s)", String.join((CharSequence)", ", propertyDescriptor.getEnumValues()));
        }
        if (propertyDescriptor.getKind().isSimple() && propertyDescriptor.getDefaultValue() != null) {
            description = description + String.format(" default(%s)", propertyDescriptor.getDefaultValue());
        }
        this.setDescription(description);
    }

    private void initTypeHint(PropertyDescriptor propertyDescriptor) {
        this.addTypeHintForRequiredProperty(propertyDescriptor);
        this.addTypeHintFromEnumProperty(propertyDescriptor);
        this.addTypeHintFromPropertyValidationRules(propertyDescriptor);
        this.copyTypeHintFromDeployedTypeHint(propertyDescriptor);
    }

    private TypeHint getOrCreateTypeHint(PropertyKind kind) {
        TypeHint typeHint = this.getTypeHint() != null ? this.getTypeHint() : new TypeHint();
        typeHint.setKind(kind);
        return typeHint;
    }

    private void addTypeHintForRequiredProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.isRequired()) {
            TypeHint typeHint = this.getOrCreateTypeHint(propertyDescriptor.getKind());
            typeHint.setRequired(true);
            this.setTypeHint(typeHint);
        }
    }

    private void addTypeHintFromEnumProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getKind() == PropertyKind.ENUM) {
            TypeHint typeHint = this.getOrCreateTypeHint(propertyDescriptor.getKind());
            typeHint.addEnumValues(propertyDescriptor.getEnumValues());
            this.setTypeHint(typeHint);
        }
    }

    private void addTypeHintFromPropertyValidationRules(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor instanceof LocalPropertyDescriptor) {
            LocalPropertyDescriptor localPropertyDescriptor = (LocalPropertyDescriptor)propertyDescriptor;
            if (!localPropertyDescriptor.validationRules.isEmpty()) {
                TypeHint typeHint = this.getOrCreateTypeHint(propertyDescriptor.getKind());
                typeHint.setKind(propertyDescriptor.getKind());
                typeHint.getValidationRules().addAll(localPropertyDescriptor.validationRules);
                this.setTypeHint(typeHint);
            }
        }
    }

    private void copyTypeHintFromDeployedTypeHint(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getTypeHint() != null) {
            this.setTypeHint(this.getOrCreateTypeHint(propertyDescriptor.getKind()).copyFrom(propertyDescriptor.getTypeHint()));
        }
    }

    public Object get(ConfigurationItem item) {
        return this.getDeclaringDescriptor().getSyntheticPropertyValue(item, this.getName());
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        this.getDeclaringDescriptor().setSyntheticPropertyValue(item, this.getName(), value);
    }
}

