package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;

import static com.xebialabs.deployit.booter.local.utils.Strings.deCamelize;
import static com.xebialabs.overthere.util.OverthereUtils.checkArgument;

class ExtendByPropertyDescriptor extends LocalPropertyDescriptor {

    private LocalPropertyDescriptor superPropertyDescriptor;

    public ExtendByPropertyDescriptor(LocalPropertyDescriptor base, LocalPropertyDescriptor superPropertyDescriptor) {
        setDeclaringDescriptor(base.getDeclaringDescriptor());
        setFromPropertyDescriptor(base);
        extendWith(superPropertyDescriptor);
        addDefaultValidationRules();
        this.superPropertyDescriptor = superPropertyDescriptor;
        registerDefault(GlobalContext.lookup(base));
    }

    private void extendWith(LocalPropertyDescriptor superDescriptor) {
        checkArgument(
                superDescriptor.getKind() == this.getKind(),
                "Type '%s' attempts to overrides property '%s' declared in type '%s', but kind attribute does not match. Derived kind: '%s'. Super kind: '%s'.",
                getDeclaringDescriptor().getType(), getName(),
                superDescriptor.getDeclaringDescriptor().getType(),
                getKind(), superDescriptor.getKind());
        checkOverrideArgument((superDescriptor.getReferencedType() == null && this.getReferencedType() == null) ||
                (superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().equals(this.getReferencedType())) ||
                (superDescriptor.getReferencedType() != null && superDescriptor.getReferencedType().isSuperTypeOf(this.getReferencedType())), "referenceType", superDescriptor.getReferencedType() + " or a subtype thereof", superDescriptor);
        checkOverrideArgument(superDescriptor.getEnumClass() == this.getEnumClass(), "enumClass", superDescriptor.getEnumClass(), superDescriptor);

        setAsContainment(superDescriptor.isAsContainment());
        if (!isPassword() && superDescriptor.isPassword()) {
            logger.warn("Type extension for {} does not define property {} as password, but super-type {} does.",
                    getDeclaringDescriptor().getType(),
                    getName(),
                    superDescriptor.getDeclaringDescriptor().getType());
            setPassword(true);
        }
        setCandidateValuesFilter(superDescriptor.getCandidateValuesFilter());
        if(!isRequired()) {
            setRequired(superDescriptor.isRequired());
        }

        if (superDescriptor.isInspectionProperty()) {
            setInspectionProperty(true);
            setRequiredForInspection(superDescriptor.isRequiredForInspection());
        }

        // In type modifications, the description and label might not be set, copy the description and/or the label from the previous version of the descriptor in that case.
        if (getDescription().equals(getLabel())) {
            setDescription(superDescriptor.getDescription());
        }
        if (getLabel().equals(deCamelize(getName()))) {
            setLabel(superDescriptor.getLabel());
        }
        if (getCategory().equals("Common")) {
            setCategory(superDescriptor.getCategory());
        }
        if (getSize() == Property.Size.DEFAULT) {
            setSize(superDescriptor.getSize());
        }
        setDeployedSpecific(superDescriptor.isDeployedSpecific());
    }

    private void checkOverrideArgument(boolean condition, String attribute, Object expectedValue, PropertyDescriptor superDescriptor) {
        final String attributeErrorTemplate = "Type '%s' attempts to overrides property '%s' declared in type '%s', but '%s' attribute does not match that in the super type. Should be set to %s.";
        checkArgument(condition, attributeErrorTemplate, getDeclaringDescriptor().getType(), getName(), ((LocalPropertyDescriptor) superDescriptor).getDeclaringDescriptor().getType(), attribute, expectedValue);
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        superPropertyDescriptor.set(item, value);
    }

    @Override
    public Object get(ConfigurationItem item) {
        return superPropertyDescriptor.get(item);
    }
}
