package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import org.w3c.dom.Element;

import java.util.Optional;

import static com.xebialabs.deployit.booter.local.utils.XmlUtils.*;


class GeneratedParameterLocalDescriptor extends LocalDescriptor {

    public GeneratedParameterLocalDescriptor(final Type type, final Element methodDef) {
        setType(type);
        initParameters(methodDef);
        initHierarchy();
    }

    private void initParameters(final Element methodDef) {
        addSuperClass(Type.valueOf(Parameters.class));
        String name = getRequiredStringAttribute(methodDef, "name");
        setDescription("Generated type for method " + name + ".");
        setRootName(Optional.empty());
        Element parameters = childByName(methodDef, "parameters"::equals).next();
        for (Element parameter : childrenByName(parameters, "parameter"::equals)) {
            LocalPropertyDescriptor propDesc = new SyntheticLocalPropertyDescriptor(GeneratedParameterLocalDescriptor.this, parameter);
            addPropertyDescriptor(propDesc);
        }
    }

}
