/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedSpecific;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

class FieldBasedPropertyDescriptor
extends LocalPropertyDescriptor {
    private Field field;

    public FieldBasedPropertyDescriptor(LocalDescriptor descriptor, Field field) {
        this.field = field;
        this.field.setAccessible(true);
        this.setName(field.getName());
        Property property = field.getAnnotation(Property.class);
        this.setDeclaringDescriptor(descriptor);
        this.initMetadata(property);
        this.initType(property);
        this.initInspectionMetadata(field);
        this.reInitializeRequired();
        this.initValidationMetadata(field);
        this.setDeployedSpecific(field.isAnnotationPresent(DeployedSpecific.class));
    }

    private void initValidationMetadata(Field field) {
        this.addDefaultValidationRules();
        for (Annotation annotation : field.getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            this.validationRules.add(ValidationRuleConverter.makeRule(annotation, (LocalPropertyDescriptor)this));
        }
    }

    private void initInspectionMetadata(Field field) {
        if (field.isAnnotationPresent(InspectionProperty.class)) {
            this.setInspectionProperty(true);
            this.setRequiredForInspection(field.getAnnotation(InspectionProperty.class).required());
        }
    }

    private void initMetadata(Property annotation) {
        this.setCategory(annotation.category());
        this.setLabel(Strings.isBlank(annotation.label()) ? Strings.deCamelize(this.getName()) : annotation.label());
        this.setDescription(Strings.isBlank(annotation.description()) ? this.getLabel() : annotation.description());
        this.setPassword(annotation.password());
        this.setRequired(annotation.required());
        this.setSize(annotation.size());
        this.setHidden(annotation.hidden());
        this.setCandidateValuesFilter(Strings.defaultIfEmpty(annotation.candidateValuesFilter().trim(), null));
        this.setTransient(this.isHidden() || annotation.isTransient());
    }

    private void initType(Property annotation) {
        Class<?> type = this.field.getType();
        if (type == Boolean.TYPE) {
            this.setKind(PropertyKind.BOOLEAN);
        } else if (type == Integer.TYPE || type == Integer.class) {
            this.setKind(PropertyKind.INTEGER);
        } else if (type == String.class) {
            this.setKind(PropertyKind.STRING);
        } else if (type.isEnum()) {
            this.setKind(PropertyKind.ENUM);
            this.initEnumValues(this.field.getType());
        } else if (type == Date.class) {
            this.setKind(PropertyKind.DATE);
        } else if (ConfigurationItem.class.isAssignableFrom(type)) {
            this.setKind(PropertyKind.CI);
            this.setReferencedType(Type.valueOf(type));
            this.setAsContainment(annotation.asContainment());
        } else if (Set.class.isAssignableFrom(type)) {
            this.initSetType(annotation);
        } else if (Map.class.isAssignableFrom(type)) {
            this.initMapType();
        } else if (List.class.isAssignableFrom(type)) {
            this.initListType(annotation);
        } else {
            throw new IllegalArgumentException(String.format("Type of %s not supported as an @Property field, found on %s.%s", type.getName(), this.field.getDeclaringClass().getName(), this.getName()));
        }
        this.registerDefault(Strings.defaultIfEmpty(annotation.defaultValue(), null));
    }

    private void initSetType(Property annotation) {
        Class<?> setType = this.getGenericType(Set.class, 1, 0);
        if (setType == String.class) {
            this.setKind(PropertyKind.SET_OF_STRING);
        } else if (ConfigurationItem.class.isAssignableFrom(setType)) {
            this.setKind(PropertyKind.SET_OF_CI);
            this.setReferencedType(Type.valueOf(setType));
            this.setAsContainment(annotation.asContainment());
        } else {
            throw new IllegalStateException(String.format("Unsupported Set type encountered for [%s]. Only support String and ConfigurationItem", this.getName()));
        }
    }

    private void initMapType() {
        OverthereUtils.checkArgument((this.getGenericType(Map.class, 2, 0) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.getName()});
        OverthereUtils.checkArgument((this.getGenericType(Map.class, 2, 1) == String.class ? 1 : 0) != 0, (String)"Property %s.%s of type Map should be Map<String, String>", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.getName()});
        this.setKind(PropertyKind.MAP_STRING_STRING);
    }

    private Class<?> getGenericType(Class<?> collectionClass, int nrExpectedTypes, int indexOfType) {
        java.lang.reflect.Type genericType = this.field.getGenericType();
        OverthereUtils.checkArgument((boolean)(genericType instanceof ParameterizedType), (String)"The field %s.%s is a %s but it isn't a generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.getName(), collectionClass, genericType});
        Object[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
        OverthereUtils.checkArgument((actualTypeArguments.length == nrExpectedTypes ? 1 : 0) != 0, (String)"The field %s is a %s.%s but it doesn't have the right generic type (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.getName(), collectionClass, actualTypeArguments});
        OverthereUtils.checkArgument((boolean)(actualTypeArguments[indexOfType] instanceof Class), (String)"The field %s.%s is a %s but it is not a concrete subclass (%s)", (Object[])new Object[]{this.field.getDeclaringClass().getName(), this.getName(), collectionClass, Arrays.toString(actualTypeArguments)});
        return (Class)actualTypeArguments[indexOfType];
    }

    private void initListType(Property annotation) {
        Class<?> listType = this.getGenericType(List.class, 1, 0);
        if (listType == String.class) {
            this.setKind(PropertyKind.LIST_OF_STRING);
        } else if (ConfigurationItem.class.isAssignableFrom(listType)) {
            this.setKind(PropertyKind.LIST_OF_CI);
            this.setReferencedType(Type.valueOf(listType));
            this.setAsContainment(annotation.asContainment());
        } else {
            throw new IllegalStateException(String.format("Unsupported List type encountered for [%s]. Only support String and ConfigurationItem", this.getName()));
        }
    }

    @Override
    protected void reInitializeRequired() {
        super.reInitializeRequired();
        if (this.field.getType().equals(Integer.TYPE) && !this.isRequired()) {
            this.logger.warn("Optional integer property [{}] backed by a Java int field will be treated as a required property.", (Object)this);
            this.setRequired(true);
        }
    }

    public Object get(ConfigurationItem item) {
        try {
            return this.field.get(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot get field " + this.field, e);
        }
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        if (value != null) {
            try {
                this.field.set(item, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot get field " + this.field, e);
            }
        }
    }
}

