/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.validation.ApplicableTo;
import com.xebialabs.deployit.plugin.api.validation.Rule;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class ValidationRuleConverter {
    public static final String RULE_ELEMENT_NAME = "rule";
    private static final Map<String, Class<?>> ruleTypeMap = Maps.newHashMap();

    ValidationRuleConverter() {
    }

    static Validator<?> makeRule(Annotation validationRuleAnnotation, Type ciType) {
        Class<? extends Annotation> vraClazz = validationRuleAnnotation.annotationType();
        ValidationRuleConverter.checkApplicability(vraClazz, ciType);
        return ValidationRuleConverter.createRule(validationRuleAnnotation, vraClazz);
    }

    static Validator<?> makeRule(Element element, Type ciType) {
        Class<?> vraClazz = ValidationRuleConverter.getValidationRuleAnnotationClass(element, ciType.toString());
        ValidationRuleConverter.checkApplicability(vraClazz, ciType);
        return ValidationRuleConverter.createRule(element, vraClazz);
    }

    static Validator<?> makeRule(Annotation validationRuleAnnotation, LocalPropertyDescriptor propertyDescriptor) {
        Class<? extends Annotation> vraClazz = validationRuleAnnotation.annotationType();
        ValidationRuleConverter.checkApplicability(vraClazz, propertyDescriptor);
        return ValidationRuleConverter.createRule(validationRuleAnnotation, vraClazz);
    }

    static Validator<?> makeRule(Element element, LocalPropertyDescriptor propertyDescriptor) {
        Class<?> vraClazz = ValidationRuleConverter.getValidationRuleAnnotationClass(element, propertyDescriptor.getFqn());
        ValidationRuleConverter.checkApplicability(vraClazz, propertyDescriptor);
        return ValidationRuleConverter.createRule(element, vraClazz);
    }

    static boolean isRule(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Rule.class);
    }

    private static Class<?> getValidationRuleAnnotationClass(Element element, String fqn) {
        String type = element.getAttribute("type");
        Class<?> vraClazz = ruleTypeMap.get(type);
        if (vraClazz == null) {
            throw new IllegalArgumentException(String.format("Could not find validation rule type %s defined on property %s", type, fqn));
        }
        return vraClazz;
    }

    private static Validator<?> createRule(Annotation validationRuleAnnotation, Class<?> vraClazz) {
        Rule rule = vraClazz.getAnnotation(Rule.class);
        Validator<?> validationRule = ValidationRuleConverter.instantiate(rule.clazz());
        for (Method method : vraClazz.getDeclaredMethods()) {
            Object annotationValue = ValidationRuleConverter.getAnnotationValue(validationRuleAnnotation, method);
            ReflectionUtils.setField(validationRule, method.getName(), annotationValue);
        }
        return validationRule;
    }

    private static Validator<?> createRule(Element element, Class<?> vraClazz) {
        Validator<?> validationRule = ValidationRuleConverter.instantiate(vraClazz.getAnnotation(Rule.class).clazz());
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (name.equals("type")) continue;
            ReflectionUtils.setFieldWithConversion(validationRule, name, attr.getValue());
        }
        return validationRule;
    }

    private static void checkApplicability(Class<?> vraClazz, Type ciType) {
        if (vraClazz.isAnnotationPresent(Target.class)) {
            Target annotation = vraClazz.getAnnotation(Target.class);
            Preconditions.checkArgument((boolean)Lists.newArrayList((Object[])annotation.value()).contains((Object)ElementType.TYPE), (String)"Validation rule [%s] is not applicable to type [%s], because it is not a type level validation", (Object[])new Object[]{vraClazz.getAnnotation(Rule.class).type(), ciType});
        }
    }

    private static void checkApplicability(Class<?> vraClazz, LocalPropertyDescriptor propertyDescriptor) {
        if (vraClazz.isAnnotationPresent(ApplicableTo.class)) {
            ArrayList propertyKinds = Lists.newArrayList((Object[])vraClazz.getAnnotation(ApplicableTo.class).value());
            Preconditions.checkArgument((boolean)propertyKinds.contains(propertyDescriptor.getKind()), (String)"Validation rule [%s] is not applicable to property [%s], because it is not of type(s) %s", (Object[])new Object[]{vraClazz.getAnnotation(Rule.class).type(), propertyDescriptor.getFqn(), propertyKinds});
        }
        if (vraClazz.isAnnotationPresent(Target.class)) {
            Target annotation = vraClazz.getAnnotation(Target.class);
            Preconditions.checkArgument((boolean)Lists.newArrayList((Object[])annotation.value()).contains((Object)ElementType.FIELD), (String)"Validation rule [%s] is not applicable to property [%s], because it is not a property level validation", (Object[])new Object[]{vraClazz.getAnnotation(Rule.class).type(), propertyDescriptor.getFqn()});
        }
    }

    private static Validator<?> instantiate(Class<? extends Validator<?>> rule) {
        try {
            return rule.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        }
    }

    private static Object getAnnotationValue(Annotation validationRuleAnnotation, Method method) {
        try {
            return method.invoke((Object)validationRuleAnnotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not invoke method.", e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not convert validation rule.");
        }
    }

    static {
        Set rules = Scannit.getInstance().getTypesAnnotatedWith(Rule.class);
        for (Class validationRuleAnnotation : rules) {
            Rule rule = validationRuleAnnotation.getAnnotation(Rule.class);
            ruleTypeMap.put(rule.type(), validationRuleAnnotation);
        }
    }
}

