/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class TypeDefinitions {
    private final Map<Type, TypeDefinition> typeDefs = Maps.newHashMap();
    private LocalDescriptorRegistry registry;
    private static final Logger logger = LoggerFactory.getLogger(TypeDefinitions.class);

    public TypeDefinitions(LocalDescriptorRegistry registry) {
        this.registry = registry;
    }

    void defineType(Class clazz) {
        ClassBasedTypeDefinition typeDef = new ClassBasedTypeDefinition(clazz);
        this.registerTypeDefinition(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    protected void registerTypeDefinition(TypeDefinition typeDef) {
        Preconditions.checkState((!this.typeDefs.containsKey(typeDef.type) ? 1 : 0) != 0, (String)"Trying to register duplicate definition for type [%s]. Existing: [%s], duplicate: [%s]", (Object[])new Object[]{typeDef.type, this.typeDefs.get(typeDef.type), typeDef});
        this.typeDefs.put(typeDef.type, typeDef);
    }

    void defineType(Element element) {
        SyntheticBasedTypeDefinition typeDef = new SyntheticBasedTypeDefinition(element);
        this.registerTypeDefinition(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineGeneratedType(Element element, Element owner) {
        GeneratedTypeDefinition typeDef = new GeneratedTypeDefinition(owner, element);
        this.registerTypeDefinition(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void defineGeneratedParameterType(Element methodDef, Element type) {
        GeneratedParameterTypeDefinition typeDef = new GeneratedParameterTypeDefinition(type, methodDef);
        this.registerTypeDefinition(typeDef);
        logger.debug("Found: {}", (Object)typeDef);
    }

    void modifyType(Element element) {
        TypeMod typeMod = new TypeMod(XmlUtils.getRequiredTypeAttribute(element, "type"), element);
        Preconditions.checkState((boolean)this.typeDefs.containsKey(typeMod.type), (String)"Detected type-modification for non-existing type [%s]", (Object[])new Object[]{typeMod.type});
        this.typeDefs.get((Object)((TypeMod)typeMod).type).typeModifications.push(typeMod);
        logger.debug("Found: {}", (Object)typeMod);
    }

    Collection<TypeDefinition> getDefinitions() {
        return Lists.newArrayList(this.typeDefs.values());
    }

    TypeDefinition getDefinition(Type type) {
        return (TypeDefinition)Preconditions.checkNotNull((Object)this.typeDefs.get(type), (String)"Could not find a type definition associated with type [%s]", (Object[])new Object[]{type});
    }

    private static Type type(Class<?> clazz) {
        if (clazz != null && ConfigurationItem.class.isAssignableFrom(clazz)) {
            return Type.valueOf(clazz);
        }
        return null;
    }

    public static Type generatedParameterType(Type type, String name) {
        return Type.valueOf((String)(type.toString() + "_" + name));
    }

    class GeneratedParameterTypeDefinition
    extends TypeDefinition {
        private final Type owner;
        private final Element methodDef;

        public GeneratedParameterTypeDefinition(Element owner, Element methodDef) {
            this.owner = XmlUtils.getRequiredTypeAttribute(owner, "type");
            this.methodDef = methodDef;
            String methodName = XmlUtils.getRequiredStringAttribute(methodDef, "name");
            this.type = TypeDefinitions.generatedParameterType(this.owner, methodName);
            this.parent = Type.valueOf(Parameters.class);
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            if (!LocalDescriptorRegistry.exists((Type)this.owner)) {
                typeDefinitions.getDefinition(this.owner).register(typeDefinitions);
            }
            return LocalDescriptor.fromGeneratedParameters(this.type, this.methodDef);
        }
    }

    class GeneratedTypeDefinition
    extends SyntheticBasedTypeDefinition {
        Type owner;

        private GeneratedTypeDefinition(Element owner, Element generatedElement) {
            super(generatedElement);
            this.owner = XmlUtils.getRequiredTypeAttribute(owner, "type");
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            if (!LocalDescriptorRegistry.exists((Type)this.owner)) {
                typeDefinitions.getDefinition(this.owner).register(typeDefinitions);
            }
            return LocalDescriptor.fromGenerateDeployable((LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)this.owner));
        }
    }

    class SyntheticBasedTypeDefinition
    extends TypeDefinition {
        private Element element;

        public SyntheticBasedTypeDefinition(Element element) {
            this.element = element;
            this.type = XmlUtils.getRequiredTypeAttribute(element, "type");
            this.parent = XmlUtils.getRequiredTypeAttribute(element, "extends");
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            return LocalDescriptor.fromSynthetic(this.element);
        }
    }

    class ClassBasedTypeDefinition
    extends TypeDefinition {
        private Class<? extends ConfigurationItem> clazz;
        private List<Type> interfaces;

        public ClassBasedTypeDefinition(Class<? extends ConfigurationItem> ci) {
            this.interfaces = Lists.newArrayList();
            this.type = TypeDefinitions.type(ci);
            this.parent = TypeDefinitions.type(ci.getSuperclass());
            this.interfaces = Lists.newArrayList((Iterable)Collections2.transform((Collection)Collections2.filter(ReflectionUtils.getAllInterfaces(ci), (Predicate)new Predicate<Class<?>>(){

                public boolean apply(Class<?> input) {
                    return TypeDefinitions.type(input) != null;
                }
            }), (Function)new Function<Class<?>, Type>(){

                public Type apply(Class<?> input) {
                    return TypeDefinitions.type(input);
                }
            }));
            this.clazz = ci;
        }

        @Override
        protected LocalDescriptor createDescriptor(TypeDefinitions typeDefinitions) {
            for (Type anInterface : this.interfaces) {
                if (LocalDescriptorRegistry.exists((Type)anInterface)) continue;
                typeDefinitions.getDefinition(anInterface).register(typeDefinitions);
            }
            return LocalDescriptor.from(this.clazz);
        }

        @Override
        protected void registerAsSubtype(Type type) {
            super.registerAsSubtype(type);
            for (Type anInterface : this.interfaces) {
                TypeDefinitions.this.registry.registerSubtype(anInterface, type);
            }
        }
    }

    abstract class TypeDefinition {
        Type type;
        Type parent;
        Deque<TypeMod> typeModifications = new ArrayDeque<TypeMod>();

        TypeDefinition() {
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.type + "]";
        }

        final void register(TypeDefinitions typeDefinitions) {
            if (LocalDescriptorRegistry.exists((Type)this.type)) {
                return;
            }
            if (this.parent != null && !LocalDescriptorRegistry.exists((Type)this.parent)) {
                typeDefinitions.getDefinition(this.parent).register(typeDefinitions);
            }
            LocalDescriptor descriptor = this.createDescriptor(typeDefinitions);
            TypeDefinitions.this.registry.register(descriptor);
            this.applyTypeModifications(descriptor);
        }

        protected abstract LocalDescriptor createDescriptor(TypeDefinitions var1);

        void applyTypeModifications(LocalDescriptor descriptor) {
            for (TypeMod typeModification : this.typeModifications) {
                descriptor.parseTypeModification(typeModification.modification);
            }
        }

        final void registerTypeTree() {
            this.registerAsSubtype(this.type);
        }

        protected void registerAsSubtype(Type type) {
            if (this.parent != null) {
                TypeDefinitions.this.registry.registerSubtype(this.parent, type);
                TypeDefinitions.this.getDefinition(this.parent).registerAsSubtype(type);
            }
        }
    }

    class TypeMod {
        private Type type;
        private Element modification;

        protected TypeMod(Type type, Element modification) {
            this.type = type;
            this.modification = modification;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.type + "]";
        }
    }
}

