package com.xebialabs.deployit.booter.local;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import com.google.common.collect.Maps;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.Verification;
import com.xebialabs.deployit.plugin.api.reflect.Verify;

import nl.javadude.scannit.Scannit;

class VerificationConverter {

    public static final String VERIFICATION_ELEMENT_NAME = "verification";

    private static final Map<String, Class<? extends Verification>> verificationTypeMap = Maps.newHashMap();

    static {
        Set<Class<?>> rules = Scannit.getInstance().getTypesAnnotatedWith(Verify.class);
        for (Class<?> validationRuleAnnotation : rules) {
            Verify verify = validationRuleAnnotation.getAnnotation(Verify.class);
            verificationTypeMap.put(verify.type(), verify.clazz());
        }
    }

    static boolean isVerification(Annotation annotation) {
        return annotation.annotationType().isAnnotationPresent(Verify.class);
    }

    @SuppressWarnings("unchecked")
    static <T extends Verification> T makeVerification(Annotation verificationAnnotation) {
        Class<? extends Annotation> verificationClazz = verificationAnnotation.annotationType();
        Verify verify = verificationClazz.getAnnotation(Verify.class);
        return (T) instantiate(verify.clazz());
    }

    @SuppressWarnings("unchecked")
    static <T extends Verification> T makeVerification(Element element, Type ciType) {
        String type = element.getAttribute("type");
        T rule = (T) createRule(type);
        if (rule != null) {
            return rule;
        }
        throw new IllegalArgumentException(String.format("Could not find verification type %s defined on type %s", type, ciType));
    }

    private static Verification createRule(String type) {
        if (verificationTypeMap.containsKey(type)) {
            return instantiate(verificationTypeMap.get(type));
        }
        return null;
    }

    private static Verification instantiate(Class<? extends Verification> rule) {
        try {
            return rule.newInstance();
        } catch (InstantiationException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        } catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot instantiate validation rule " + rule, e);
        }
    }
}
