package com.xebialabs.deployit.booter.local.validation;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;

public class CollectionTypeValidator implements Validator<Collection<?>> {

    private PropertyDescriptor propertyDescriptor;

    public CollectionTypeValidator(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void validate(Collection<?> value, ValidationContext context) {
        PropertyKind kind = propertyDescriptor.getKind();
        if (EnumSet.of(PropertyKind.LIST_OF_CI, PropertyKind.LIST_OF_STRING).contains(kind) && !(value instanceof List)) {
            context.error("Property [%s] expected a collection of type java.util.List but got [%s]", propertyDescriptor.getFqn(), value.getClass());
        } else if (EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.SET_OF_STRING).contains(kind) && !(value instanceof Set)) {
            context.error("Property [%s] expected a collection of type java.util.Set but got [%s]", propertyDescriptor.getFqn(), value.getClass());
        }
    }
}
