package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.common.base.Joiner;

import static com.google.common.collect.Lists.newArrayList;
import static java.lang.String.format;

class Verifications {
    private List<String> verifications = newArrayList();

    Verifications() {
    }

    void verify(Type t, boolean condition, String messageTemplate, Object... parameters) {
        if (!condition) {
            verifications.add(t + ": " + format(messageTemplate, parameters));
        }
    }

    void verify(boolean condition, String messageTemplate, Object... parameters) {
        if (!condition) {
            verifications.add(format(messageTemplate, parameters));
        }
    }

    void done() {
        if (!verifications.isEmpty()) {
            logger.error("Verifications failed:");
            for (String s : verifications) {
                logger.error(s);
            }
            throw new IllegalStateException("There is an error in the defined types: \n" + Joiner.on("\n").join(verifications));
        }
    }

    private static final Logger logger = LoggerFactory.getLogger(LocalBooter.class);
}
