/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.CiIconResolver;
import com.xebialabs.deployit.booter.local.ConfigurationItemPostProcessors;
import com.xebialabs.deployit.booter.local.DescriptorVerification;
import com.xebialabs.deployit.booter.local.ExtendByPropertyDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptorHelper;
import com.xebialabs.deployit.booter.local.LocalDescriptorRegistry;
import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.LocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticLocalPropertyDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.CreatorDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.xlplatform.synthetic.MethodSpecification;
import com.xebialabs.xlplatform.synthetic.PropertySpecification;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.ValidationRuleSpecification;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalDescriptor
implements Descriptor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Type type;
    private Class<? extends ConfigurationItem> clazz;
    private String label;
    private String description;
    private Optional<String> rootName = Optional.empty();
    private final List<Type> superclasses = new ArrayList<Type>();
    private final Set<Type> interfaces = new LinkedHashSet<Type>();
    private boolean virtual = false;
    private boolean versioned = true;
    private String icon;
    private boolean isInspectable;
    private Map<String, LocalPropertyDescriptor> properties = new LinkedHashMap<String, LocalPropertyDescriptor>();
    private Map<String, MethodDescriptor> controlTasks = new HashMap<String, MethodDescriptor>();
    private Type deployableType;
    private Type containerType;
    private CreatorDescriptor creator;
    protected List<Validator<ConfigurationItem>> validators = new ArrayList<Validator<ConfigurationItem>>();
    protected transient List<TypeVerification> verifications = new ArrayList<TypeVerification>();
    protected transient boolean ownIcon = false;
    private Field syntheticPropertiesField;

    public Type getType() {
        return this.type;
    }

    protected void setType(Type type) {
        this.type = type;
    }

    public Class<? extends ConfigurationItem> getClazz() {
        return this.clazz;
    }

    protected void setClazz(Class<? extends ConfigurationItem> clazz) {
        this.clazz = clazz;
    }

    public String getRootName() {
        return this.rootName.orElse("");
    }

    protected Optional<String> getRootNameMaybe() {
        return this.rootName;
    }

    protected void setRootName(Optional<String> rootName) {
        this.rootName = rootName;
    }

    public String getLabel() {
        return this.label;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    public List<Type> getSuperClasses() {
        return Collections.unmodifiableList(this.superclasses);
    }

    protected void addSuperClass(Type supertype) {
        this.superclasses.add(supertype);
    }

    public Set<Type> getInterfaces() {
        return Collections.unmodifiableSet(this.interfaces);
    }

    protected void addInterface(Type intf) {
        this.interfaces.add(intf);
    }

    public String getIcon() {
        return this.icon;
    }

    protected void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    protected void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    protected void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public boolean isInspectable() {
        return this.isInspectable;
    }

    protected void setInspectable(boolean inspectable) {
        this.isInspectable = inspectable;
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.isAssignableTo(Type.valueOf(clazz));
    }

    public boolean isAssignableTo(Type type) {
        return this.getType().isSubTypeOf(type) || this.getType().equals((Object)type);
    }

    public CreatorDescriptor getCreator() {
        return this.creator;
    }

    public void setCreator(CreatorDescriptor creator) {
        this.creator = creator;
    }

    protected void addPropertyDescriptor(LocalPropertyDescriptor propertyDescriptor) {
        this.properties.put(propertyDescriptor.getName(), propertyDescriptor);
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        return new ArrayList<PropertyDescriptor>(this.properties.values());
    }

    protected Map<String, LocalPropertyDescriptor> getPropertyDescriptorsAsMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.properties.get(name);
    }

    protected void addControlTask(MethodDescriptor from) {
        this.controlTasks.put(from.getName(), from);
    }

    public MethodDescriptor getControlTask(String name) {
        return this.controlTasks.get(name);
    }

    public Collection<MethodDescriptor> getControlTasks() {
        return Collections.unmodifiableCollection(this.controlTasks.values());
    }

    protected Map<String, MethodDescriptor> getControlTasksAsMap() {
        return Collections.unmodifiableMap(this.controlTasks);
    }

    protected void applyTypeModification(TypeModificationSpecification modificationSpec) {
        this.setVersioned(modificationSpec.getVersioned().orElse(this.isVersioned()));
        this.setVirtual(modificationSpec.getVirtual().orElse(this.isVirtual()));
        this.validators.addAll(LocalDescriptor.createValidators(modificationSpec.getValidators(), this.getType()));
        this.verifications.addAll(LocalDescriptor.createVerifications(modificationSpec.getVerifications(), this.getType()));
        modificationSpec.getControlTasks().forEach(this::validateAndAddControlTask);
        this.getPropertyDescriptors(modificationSpec.getProperties()).forEach(this::overrideOrAddPropertyDescriptor);
    }

    protected static List<Validator<ConfigurationItem>> createValidators(List<ValidationRuleSpecification> valSpecs, Type type) {
        ArrayList<Validator<ConfigurationItem>> validators = new ArrayList<Validator<ConfigurationItem>>();
        for (ValidationRuleSpecification ruleSpec : valSpecs) {
            validators.add(ValidationRuleConverter.makeRule(ruleSpec, type));
        }
        return validators;
    }

    protected static List<TypeVerification> createVerifications(List<String> types, Type type) {
        ArrayList<TypeVerification> verifications = new ArrayList<TypeVerification>();
        for (String typeName : types) {
            verifications.add((TypeVerification)VerificationConverter.makeVerification(typeName, type));
        }
        return verifications;
    }

    protected List<LocalPropertyDescriptor> getPropertyDescriptors(List<PropertySpecification> propertySpecifications) {
        ArrayList<LocalPropertyDescriptor> propertyDescriptors = new ArrayList<LocalPropertyDescriptor>();
        for (PropertySpecification propertySpecification : propertySpecifications) {
            propertyDescriptors.add(new SyntheticLocalPropertyDescriptor(this, propertySpecification));
        }
        return propertyDescriptors;
    }

    protected void validateAndAddControlTask(MethodSpecification methodSpecification) {
        MethodDescriptor methodDescriptor = LocalMethodDescriptor.from((Descriptor)this, methodSpecification);
        this.verifyNewControlTask(methodDescriptor);
        this.addControlTask(methodDescriptor);
    }

    protected void verifyNewControlTask(MethodDescriptor controlTask) {
        if (this.getControlTasksAsMap().containsKey(controlTask.getName())) {
            throw new IllegalStateException("Cannot override existing Control Task [" + controlTask.getFqn() + "] with a synthetic one.");
        }
    }

    protected void overrideOrAddPropertyDescriptor(LocalPropertyDescriptor propertyDescriptor) {
        LocalPropertyDescriptor existingProperty = this.getPropertyDescriptorsAsMap().get(propertyDescriptor.getName());
        if (existingProperty != null) {
            this.addPropertyDescriptor(new ExtendByPropertyDescriptor(propertyDescriptor, existingProperty));
        } else {
            this.addPropertyDescriptor(propertyDescriptor);
        }
    }

    private void initSyntheticPropertiesField() {
        if (!this.getClazz().isInterface() && !Type.valueOf((String)"api.ValidatedConfigurationItem").equals((Object)this.getType())) {
            this.syntheticPropertiesField = ReflectionUtils.searchField(this.getClazz(), "syntheticProperties");
        }
    }

    protected Object getSyntheticPropertyValue(ConfigurationItem configurationItem, String propertyName) {
        Map<String, Object> synth = this.getSyntheticPropertyMap(configurationItem);
        return synth.get(propertyName);
    }

    protected void setSyntheticPropertyValue(ConfigurationItem configurationItem, String propertyName, Object value) {
        this.getSyntheticPropertyMap(configurationItem).put(propertyName, value);
    }

    public Type getDeployableType() {
        return this.deployableType;
    }

    protected void setContainerType(Type containerType) {
        this.containerType = containerType;
    }

    public Type getContainerType() {
        return this.containerType;
    }

    protected void setDeployableType(Type deployableType) {
        this.deployableType = deployableType;
    }

    private Map<String, Object> getSyntheticPropertyMap(ConfigurationItem configurationItem) {
        return (Map)ReflectionUtils.getField(configurationItem, this.syntheticPropertiesField);
    }

    void verify(Verifications verifications) {
        DescriptorVerification.verify(verifications, this);
        for (TypeVerification verification : this.verifications) {
            verification.verify((Descriptor)this, (message, params) -> verifications.verify(this.getType(), false, message, params));
        }
        this.verifySyntheticPropertiesField(verifications);
    }

    private void verifySyntheticPropertiesField(Verifications verifications) {
        verifications.verify(this.getType(), this.syntheticPropertiesField != null, "Synthetic properties field should be set", new Object[0]);
        if (this.syntheticPropertiesField != null) {
            verifications.verify(this.getType(), this.syntheticPropertiesField.getType().isAssignableFrom(Map.class), "Synthetic properties field should be Map<String, Object>, not: %s", this.syntheticPropertiesField.getType());
        }
    }

    public <T extends ConfigurationItem> T newInstance(String id) {
        if (this.isVirtual()) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.getType() + " because it is virtual");
        }
        try {
            Field typeField = ReflectionUtils.searchField(this.clazz, "type");
            T t = this.newCleanInstance();
            t.setId(id);
            typeField.set(t, this.getType());
            this.prefillDefaultProperties(t);
            this.callPostProcessor((ConfigurationItem)t);
            return t;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot instantiate class " + this.clazz.getName(), e);
        }
    }

    <T extends ConfigurationItem> T newCleanInstance() {
        if (Modifier.isAbstract(this.getClazz().getModifiers())) {
            throw new IllegalArgumentException("Cannot instantiate class for " + this.getType() + " because it is abstract");
        }
        Class<? extends ConfigurationItem> clazz = this.getClazz();
        try {
            Constructor<? extends ConfigurationItem> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot instantiate class " + clazz.getName(), e);
        }
    }

    private <T extends ConfigurationItem> void prefillDefaultProperties(T t) {
        for (PropertyDescriptor pd : this.getPropertyDescriptors()) {
            LocalPropertyDescriptor lpd = (LocalPropertyDescriptor)pd;
            Object defaultValue = pd.getDefaultValue();
            if (defaultValue != null) {
                pd.set(t, defaultValue);
                continue;
            }
            pd.set(t, lpd.emptyValue());
        }
    }

    private void callPostProcessor(ConfigurationItem ci) {
        ConfigurationItemPostProcessors.getProcessors(this.getType()).stream().forEach(processor -> processor.process(ci));
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return LocalDescriptorHelper.areEqualDeeply(this, item, other, new HashSet<String>());
    }

    protected String toLabel(Type type) {
        return Strings.deCamelize(type.getPrefix()) + ": " + Strings.deCamelize(type.getName());
    }

    protected void initHierarchy() {
        if (!this.getSuperClasses().isEmpty()) {
            Type toInitFrom = this.getSuperClasses().get(0);
            LocalDescriptor superDesc = (LocalDescriptor)LocalDescriptorRegistry.getDescriptor((Type)toInitFrom);
            if (superDesc == null) {
                throw new IllegalStateException("Cannot build type hierarchy for " + this.getType() + " because one of its supertypes cannot be found: " + toInitFrom + " not found");
            }
            if (!this.getRootNameMaybe().isPresent()) {
                this.setRootName(superDesc.getRootNameMaybe());
            }
            if (this.getClazz() == null) {
                this.setClazz(superDesc.getClazz());
            }
            if (this.getLabel() == null) {
                this.setLabel(this.toLabel(this.getType()));
            }
            this.inheritPropertyDescriptors(superDesc);
            this.inheritControlTasks(superDesc);
            this.inheritCreator(superDesc);
            this.inheritValidators(this.validators, superDesc.validators);
            this.inheritVerifications(this.verifications, superDesc.verifications);
            superDesc.getSuperClasses().forEach(this::addSuperClass);
            superDesc.getInterfaces().forEach(this::addInterface);
            if (this.getDeployableType() == null) {
                this.setDeployableType(superDesc.getDeployableType());
            }
            if (this.getContainerType() == null) {
                this.setContainerType(superDesc.getContainerType());
            }
        }
        this.initSyntheticPropertiesField();
    }

    protected void resolveIcon() {
        CiIconResolver.resolveIcon(this);
    }

    private void inheritValidators(List<Validator<ConfigurationItem>> dest, List<Validator<ConfigurationItem>> source) {
        dest.addAll(source);
    }

    private void inheritVerifications(List<TypeVerification> dest, List<TypeVerification> src) {
        dest.addAll(src);
    }

    private void inheritControlTasks(LocalDescriptor superTypeDescriptor) {
        for (Map.Entry<String, MethodDescriptor> sourceEntry : superTypeDescriptor.getControlTasksAsMap().entrySet()) {
            if (!this.getControlTasksAsMap().containsKey(sourceEntry.getKey())) {
                this.addControlTask(new LocalMethodDescriptor((LocalMethodDescriptor)sourceEntry.getValue(), this));
                continue;
            }
            this.logger.warn("Not inheriting ControlTask [{}] on [{}]", new Object[]{sourceEntry.getValue().getFqn(), this.getType()});
        }
    }

    private void inheritCreator(LocalDescriptor superTypeDescriptor) {
        if (this.getCreator() == null) {
            this.setCreator(superTypeDescriptor.getCreator());
        }
    }

    private void inheritPropertyDescriptors(LocalDescriptor superTypeDescriptor) {
        LinkedHashMap<String, LocalPropertyDescriptor> originalProperties = new LinkedHashMap<String, LocalPropertyDescriptor>(this.properties);
        this.properties.clear();
        for (Map.Entry<String, LocalPropertyDescriptor> sourceEntry : superTypeDescriptor.getPropertyDescriptorsAsMap().entrySet()) {
            if (!originalProperties.containsKey(sourceEntry.getKey())) {
                this.properties.put(sourceEntry.getKey(), sourceEntry.getValue().copyWithNewDescriptor(this));
                continue;
            }
            LocalPropertyDescriptor originalPropertyDescriptor = (LocalPropertyDescriptor)originalProperties.get(sourceEntry.getKey());
            originalProperties.put(sourceEntry.getKey(), new ExtendByPropertyDescriptor(originalPropertyDescriptor, sourceEntry.getValue()));
        }
        this.properties.putAll(originalProperties);
    }

    public List<ValidationMessage> validate(ConfigurationItem ci) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (this.hasExternalProperty(ci, propertyDescriptor)) continue;
            ((LocalPropertyDescriptor)propertyDescriptor).validate(ci, messages);
        }
        for (Validator validator : this.validators) {
            validator.validate((Object)ci, (message, params) -> messages.add(new ValidationMessage(ci.getId(), null, String.format(message, params))));
        }
        return messages;
    }

    public List<ValidationMessage> validate(ExtendedValidationContext context, ConfigurationItem ci) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (this.hasExternalProperty(ci, propertyDescriptor)) continue;
            ((LocalPropertyDescriptor)propertyDescriptor).validate(context, ci);
        }
        for (Validator validator : this.validators) {
            validator.validate((Object)ci, (ValidationContext)context.focus(ci));
        }
        return context.getMessages();
    }

    private boolean hasExternalProperty(ConfigurationItem ci, PropertyDescriptor propertyDescriptor) {
        if (ci instanceof BaseConfigurationItem) {
            return ((BaseConfigurationItem)ci).get$externalProperties().containsKey(propertyDescriptor.getName());
        }
        return false;
    }

    public List<ValidationMessage> validateInputHint(ConfigurationItem configurationItem) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            ((LocalPropertyDescriptor)propertyDescriptor).validateInputHint(configurationItem, validationMessages);
        }
        return validationMessages;
    }

    public boolean isOwnIcon() {
        return this.ownIcon;
    }

    public void setOwnIcon(boolean ownIcon) {
        this.ownIcon = ownIcon;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getType() + "]";
    }
}

