package com.xebialabs.deployit.booter.local;

import java.io.File;

class GlobalContextInitializer {

    static void init() {
        final File defaultFile = GlobalContext.DEFAULTS;
        GlobalContext.getManager().loadStoredDefaults(defaultFile);
        GlobalContext.getManager().validateValues(defaultFile);
        GlobalContext.getManager().storeDefaults(defaultFile);
    }

    static void init(File propertiesFile, GlobalContextManager globalContextManager) {
        if (globalContextManager != null) {
            GlobalContext.setManager(globalContextManager);
        }
        GlobalContext.getManager().loadStoredDefaults(propertiesFile);
        GlobalContext.getManager().validateValues(propertiesFile);
        GlobalContext.getManager().storeDefaults(propertiesFile);
    }
}
