/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.FieldBasedPropertyDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class GetterAndSetterBasedPropertyDescriptor
extends FieldBasedPropertyDescriptor {
    private final Method getterMethod;
    private final Method setterMethod;

    public GetterAndSetterBasedPropertyDescriptor(LocalDescriptor descriptor, Field field, Class<? extends ConfigurationItem> clazz) {
        super(descriptor, field);
        String getterPrefix = field.getType().isAssignableFrom(Boolean.class) ? "is" : "get";
        String fieldSuffix = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        String getterMethodName = getterPrefix + fieldSuffix;
        try {
            this.getterMethod = clazz.getMethod(getterMethodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Getter method [%s] for property [%s] can not be found in type [%s]", getterMethodName, field.getName(), descriptor.getType().toString()));
        }
        String setterMethodName = "set" + fieldSuffix;
        this.setterMethod = Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals(setterMethodName) && method.getParameterCount() == 1 && method.getParameterTypes()[0].isAssignableFrom(field.getType())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Setter method [%s] for property [%s] can not be found in type [%s]", setterMethodName, field.getName(), descriptor.getType().toString())));
    }

    @Override
    public Object get(ConfigurationItem item) {
        try {
            return this.getterMethod.invoke((Object)item, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Unable to get property [%s] through getter [%s] on type [%s]", this.getName(), this.getterMethod.getName(), item.getClass().getName()), e);
        }
    }

    @Override
    protected void doSetValue(ConfigurationItem item, Object value) {
        try {
            this.setterMethod.invoke((Object)item, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(String.format("Unable to set property [%s] through setter [%s] on type [%s]", this.getName(), this.setterMethod.getName(), item.getClass().getName()), e);
        }
    }
}

