/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.FieldBasedPropertyDescriptor;
import com.xebialabs.deployit.booter.local.GetterAndSetterBasedPropertyDescriptor;
import com.xebialabs.deployit.booter.local.GlobalContext;
import com.xebialabs.deployit.booter.local.LocalCreatorDescriptor;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.LocalMethodDescriptor;
import com.xebialabs.deployit.booter.local.ValidationRuleConverter;
import com.xebialabs.deployit.booter.local.VerificationConverter;
import com.xebialabs.deployit.booter.local.utils.ClassUtils;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.reflect.TypeVerification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Creator;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployable;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.EmbeddedDeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.EmbeddedDeployedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class ClassBasedLocalDescriptor
extends LocalDescriptor {
    private boolean isInterface;

    ClassBasedLocalDescriptor(Class<? extends ConfigurationItem> clazz) {
        this.isInterface = clazz.isInterface();
        this.setType(Type.valueOf(clazz));
        this.setVirtual(clazz.isInterface());
        this.setClazz(clazz);
        this.initMetadata();
        this.scanClass();
        this.initHierarchy();
        this.initFieldDefaults();
        this.resolveIcon();
    }

    private void initMetadata() {
        Annotation[] declaredAnnotations;
        if (this.isInterface) {
            return;
        }
        Class<? extends ConfigurationItem> clazz = this.getClazz();
        boolean directlyAnnotated = false;
        for (Annotation declaredAnnotation : declaredAnnotations = clazz.getDeclaredAnnotations()) {
            if (!declaredAnnotation.annotationType().equals(Metadata.class)) continue;
            directlyAnnotated = true;
        }
        Metadata annotation = this.getMetadataAnnotation();
        this.setLabel(Strings.defaultIfEmpty(annotation.label(), this.toLabel(this.getType())));
        this.setDescription(annotation.description());
        if (annotation.root() == Metadata.ConfigurationItemRoot.BY_ROOT_NAME) {
            this.setRootName(Optional.of(annotation.rootName()));
        } else {
            this.setRootName(Optional.ofNullable(annotation.root().getRootNodeName()));
        }
        this.setInspectable(annotation.inspectable());
        this.setVirtual(directlyAnnotated && annotation.virtual() || Modifier.isAbstract(clazz.getModifiers()));
        this.setVersioned(annotation.versioned());
    }

    private Metadata getMetadataAnnotation() {
        Class<? extends ConfigurationItem> clazz = this.getClazz();
        return (Metadata)OverthereUtils.checkNotNull((Object)clazz.getAnnotation(Metadata.class), (String)("Class " + clazz.getName() + " or one of its ancestors does not have a @Metadata annotation"), (Object[])new Object[0]);
    }

    private void scanClass() {
        this.findProperties();
        this.findControlTasks();
        this.findInterfaces();
        this.findValidations();
        this.findVerifications();
        this.findCreator();
        Class<? extends ConfigurationItem> superclass = this.getClazz().getSuperclass();
        if (superclass != null && ConfigurationItem.class.isAssignableFrom(superclass)) {
            Type supertype = Type.valueOf(superclass);
            this.addSuperClass(supertype);
        }
        this.initDeployableAndContainerTypes();
    }

    private void initFieldDefaults() {
        if (Modifier.isAbstract(this.getClazz().getModifiers()) || !this.hasDefaultConstructor()) {
            return;
        }
        Object configurationItem = this.newCleanInstance();
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            Object fieldValue;
            if (Arrays.asList(PropertyKind.CI, PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(propertyDescriptor.getKind()) || propertyDescriptor.getDefaultValue() != null || (fieldValue = propertyDescriptor.get(configurationItem)) instanceof Collection && ((Collection)fieldValue).isEmpty() || fieldValue instanceof Map && ((Map)fieldValue).isEmpty() || fieldValue == null) continue;
            GlobalContext.register(propertyDescriptor, fieldValue.toString());
        }
    }

    private boolean hasDefaultConstructor() {
        try {
            this.getClazz().getConstructor(new Class[0]);
            return true;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }

    private void findVerifications() {
        for (Annotation annotation : this.getClazz().getAnnotations()) {
            if (!VerificationConverter.isVerification(annotation)) continue;
            this.verifications.add((TypeVerification)VerificationConverter.makeVerification(annotation));
        }
    }

    private void findValidations() {
        for (Annotation annotation : this.getClazz().getAnnotations()) {
            if (!ValidationRuleConverter.isRule(annotation)) continue;
            Validator<?> v = ValidationRuleConverter.makeRule(annotation, this.getType());
            this.validators.add(v);
        }
    }

    private void findControlTasks() {
        for (Method method : this.getClazz().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ControlTask.class)) continue;
            MethodDescriptor from = LocalMethodDescriptor.from((Descriptor)this, method);
            this.addControlTask(from);
        }
    }

    private void findCreator() {
        boolean isSet = false;
        for (Method method : this.getClazz().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Creator.class)) continue;
            OverthereUtils.checkState((!isSet ? 1 : 0) != 0, (String)"Found 2 creators for class [%s]. Only one allowed.", (Object[])new Object[]{this.getClazz()});
            OverthereUtils.checkState((boolean)method.getReturnType().equals(Void.TYPE), (String)"Creator [%s] of class [%s] must be declared to return void.", (Object[])new Object[]{method.getName(), this.getClazz()});
            OverthereUtils.checkState((method.getParameterCount() <= 2 ? 1 : 0) != 0, (String)"Creator [%s] of class [%s] has more than 2 parameters. Only 2 allowed (CreatorContext and Map)", (Object[])new Object[]{method.getName(), this.getClazz()});
            OverthereUtils.checkState((method.getParameterCount() > 0 ? 1 : 0) != 0, (String)"Creator [%s] of class [%s] must take at least one argument (CreatorContext).", (Object[])new Object[]{method.getName(), this.getClazz()});
            OverthereUtils.checkState((boolean)Modifier.isStatic(method.getModifiers()), (String)"Creator [%s] of class [%s] must be static.", (Object[])new Object[]{method.getName(), this.getClazz()});
            OverthereUtils.checkState((boolean)CreatorContext.class.isAssignableFrom(method.getParameterTypes()[0]), (String)"Creator [%s] of class [%s] must take a CreatorContext as the first parameter.", (Object[])new Object[]{method.getName(), this.getClazz()});
            if (method.getParameterCount() == 2) {
                OverthereUtils.checkState((boolean)Map.class.isAssignableFrom(method.getParameterTypes()[1]), (String)"Creator [%s] of class [%s] must take a Map<String, String> as the second parameter.", (Object[])new Object[]{method.getName(), this.getClazz()});
            }
            this.setCreator(LocalCreatorDescriptor.from((Descriptor)this, method));
            isSet = true;
        }
    }

    private void findProperties() {
        for (Field field : this.getClazz().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            FieldBasedPropertyDescriptor propertyDescriptor = field.getAnnotation(Property.class).useGetterAndSetter() ? new GetterAndSetterBasedPropertyDescriptor(this, field, this.getClazz()) : new FieldBasedPropertyDescriptor(this, field);
            this.addPropertyDescriptor(propertyDescriptor);
        }
    }

    private void findInterfaces() {
        Class<?>[] clazzInterfaces = this.getClazz().getInterfaces();
        ArrayList allInterfacesFound = new ArrayList();
        this.findAllSuperInterfaces(clazzInterfaces, allInterfacesFound);
        for (Class clazz : allInterfacesFound) {
            if (!clazz.getPackage().isAnnotationPresent(Prefix.class)) continue;
            this.addInterface(Type.valueOf((Class)clazz));
        }
    }

    private void findAllSuperInterfaces(Class<?>[] childInterfaces, List<Class<?>> allInterfacesFound) {
        for (Class<?> childInterface : childInterfaces) {
            allInterfacesFound.add(childInterface);
            this.findAllSuperInterfaces(childInterface.getInterfaces(), allInterfacesFound);
        }
    }

    private void initDeployableAndContainerTypes() {
        Class<? extends ConfigurationItem> clazz = this.getClazz();
        if (Deployed.class.isAssignableFrom(clazz)) {
            this.initDeployableAndContainerTypes(Deployed.class, Deployable.class, Container.class);
        } else if (EmbeddedDeployed.class.isAssignableFrom(clazz) && !DerivedArtifact.class.isAssignableFrom(clazz)) {
            this.initDeployableAndContainerTypes(EmbeddedDeployed.class, EmbeddedDeployable.class, EmbeddedDeployedContainer.class);
        } else if (EmbeddedDeployedArtifact.class.isAssignableFrom(clazz) && DerivedArtifact.class.isAssignableFrom(clazz)) {
            this.initDeployableAndContainerTypes(EmbeddedDeployedArtifact.class, EmbeddedDeployableArtifact.class, EmbeddedDeployedContainer.class);
        }
    }

    private void initDeployableAndContainerTypes(Class<? extends ConfigurationItem> deployedClass, Class<? extends ConfigurationItem> deployableClass, Class<? extends ConfigurationItem> containerClass) {
        Class<?> genericContainerClass;
        List<Class<?>> typeArguments = ClassUtils.getActualTypeArguments(this.getClazz().asSubclass(deployedClass), deployedClass);
        OverthereUtils.checkArgument((typeArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected a %s and a %s, but got %s", (Object[])new Object[]{deployableClass.getSimpleName(), containerClass.getSimpleName(), typeArguments});
        Class<?> genericDeployableClass = typeArguments.get(0);
        if (genericDeployableClass != null) {
            OverthereUtils.checkArgument((boolean)deployableClass.isAssignableFrom(genericDeployableClass), (String)"Expected first item to be a %s", (Object[])new Object[]{deployableClass.getSimpleName()});
            this.setDeployableType(Type.valueOf(genericDeployableClass));
        }
        if ((genericContainerClass = typeArguments.get(1)) != null) {
            OverthereUtils.checkArgument((boolean)containerClass.isAssignableFrom(genericContainerClass), (String)"Expected second item to be a %s", (Object[])new Object[]{containerClass.getSimpleName()});
            this.setContainerType(Type.valueOf(genericContainerClass));
        }
    }

    boolean isInterface() {
        return this.isInterface;
    }
}

