/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic.xml;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.xlplatform.synthetic.TypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.TypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlTypeModificationSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlTypeSpecification;
import com.xebialabs.xlplatform.synthetic.xml.XmlUtils;
import com.xebialabs.xlplatform.utils.ClassLoaderUtils$;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SyntheticXmlDocument {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticXmlDocument.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticXmlDocument.class);
    private final List<TypeSpecification> types;
    private final List<TypeModificationSpecification> typeModifications;

    private SyntheticXmlDocument(List<TypeSpecification> types, List<TypeModificationSpecification> typeModifications) {
        this.types = types;
        this.typeModifications = typeModifications;
    }

    public static SyntheticXmlDocument read(URL syntheticXML) throws IOException {
        Element docElement = SyntheticXmlDocument.readSyntheticDocument(syntheticXML).getDocumentElement();
        return SyntheticXmlDocument.create(docElement);
    }

    public List<TypeSpecification> getTypes() {
        return this.types;
    }

    public List<TypeModificationSpecification> getTypeModifications() {
        return this.typeModifications;
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema syntheticSchema = schemaFactory.newSchema(ClassLoaderUtils$.MODULE$.classLoader().getResource("synthetic.xsd"));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(syntheticSchema);
            return documentBuilderFactory;
        }
        catch (SAXException exc) {
            throw new IllegalStateException("Cannot read schema synthetic.xsd", exc);
        }
    }

    private static Document readSyntheticDocument(final URL syntheticXML) throws IOException {
        InputStream syntheticXMLStream = syntheticXML.openStream();
        try {
            final boolean[] validationErrorsFound = new boolean[1];
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exc) {
                    logger.warn("Warning while parsing " + syntheticXML, (Throwable)exc);
                }

                @Override
                public void error(SAXParseException exc) {
                    logger.error("Error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) {
                    logger.error("Fatal error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(syntheticXMLStream);
            if (validationErrorsFound[0]) {
                throw new IllegalArgumentException("One or more errors were found while parsing " + syntheticXML);
            }
            Document document = doc;
            return document;
        }
        catch (RuntimeException | ParserConfigurationException | SAXException exc) {
            throw new IllegalStateException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        finally {
            Closeables.closeQuietly(syntheticXMLStream);
        }
    }

    private static SyntheticXmlDocument create(Element docElement) {
        ArrayList<TypeSpecification> types = new ArrayList<TypeSpecification>();
        ArrayList<TypeModificationSpecification> typeModifications = new ArrayList<TypeModificationSpecification>();
        XmlUtils.childByName(docElement, "type"::equals).forEachRemaining(element -> types.add(new XmlTypeSpecification((Element)element)));
        XmlUtils.childByName(docElement, "type-modification"::equals).forEachRemaining(element -> typeModifications.add(new XmlTypeModificationSpecification((Element)element)));
        return new SyntheticXmlDocument(types, typeModifications);
    }
}

