/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.booter.local.utils.XmlUtils;
import com.xebialabs.deployit.plugin.api.creator.CreatorContext;
import com.xebialabs.deployit.plugin.api.reflect.CreatorDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.overthere.util.OverthereUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class LocalCreatorDescriptor
implements CreatorDescriptor {
    private String name;
    private String delegate;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Descriptor descriptor;

    private LocalCreatorDescriptor(Descriptor descriptor, String name) {
        this.name = name;
        this.descriptor = descriptor;
    }

    private LocalCreatorDescriptor(Descriptor descriptor, Method method) {
        this.name = method.getName();
        this.delegate = "methodInvoker";
        this.descriptor = descriptor;
    }

    LocalCreatorDescriptor(LocalCreatorDescriptor copyOf, Descriptor newOwner) {
        this.attributes = copyOf.attributes;
        this.delegate = copyOf.delegate;
        this.descriptor = newOwner;
    }

    static CreatorDescriptor from(Descriptor descriptor, Method method) {
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor(descriptor, method);
        LocalCreatorDescriptor.initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    static CreatorDescriptor from(Descriptor descriptor, Element element) {
        String delegate = XmlUtils.getRequiredStringAttribute(element, "delegate");
        LocalCreatorDescriptor creatorDescriptor = new LocalCreatorDescriptor(descriptor, delegate);
        creatorDescriptor.delegate = delegate;
        creatorDescriptor.attributes = LocalCreatorDescriptor.readAttributes(element);
        LocalCreatorDescriptor.initVerifications(creatorDescriptor);
        return creatorDescriptor;
    }

    private static void initVerifications(LocalCreatorDescriptor creatorDescriptor) {
        OverthereUtils.checkNotNull((Object)DelegateRegistry.getDelegate(creatorDescriptor.delegate, Delegate.Use.CREATOR), (String)(creatorDescriptor.delegate + " is referenced, but not registered."), (Object[])new Object[0]);
    }

    private static Map<String, String> readAttributes(Element element) {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); ++i) {
            Attr item = (Attr)xmlAttrs.item(i);
            map.put(item.getName(), item.getValue());
        }
        return map;
    }

    void verify(Verifications verifications) {
        verifications.verify(this.descriptor.getType(), DelegateRegistry.exists(this.delegate, Delegate.Use.CREATOR), "No delegate called [%s] available for creator [%s]", this.delegate, this.getFqn());
    }

    Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void invoke(CreatorContext context) {
        this.invokeDelegate(context);
    }

    private void invokeDelegate(CreatorContext context) {
        Method method = DelegateRegistry.getDelegate(this.delegate, Delegate.Use.CREATOR);
        try {
            if (method.getParameterCount() == 2) {
                method.invoke(null, context, this.attributes);
            } else {
                method.invoke(null, context);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.delegate + " on " + context.getThisCI());
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.delegate + " on " + context.getThisCI());
        }
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }
}

