/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.validation;

import com.xebialabs.deployit.plugin.api.validation.ValidationContext;
import com.xebialabs.deployit.plugin.api.validation.Validator;
import org.apache.commons.lang.StringUtils;

public class BooleanOrPlaceholderValidator
implements Validator<String> {
    public void validate(String value, ValidationContext context) {
        if (value == null) {
            return;
        }
        if (!this.isPlaceholder(value) && !this.isBoolean(value)) {
            context.error("This value is not valid. The expected type is boolean or placeholder.", new Object[]{value});
        }
    }

    private boolean isPlaceholder(String value) {
        return StringUtils.startsWith((String)value, (String)"{{") && StringUtils.endsWith((String)value, (String)"}}");
    }

    private boolean isBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }
}

