/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local.utils;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    public static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    public static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = XmlUtils.getOptionalTypeAttribute(element, attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    public static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = XmlUtils.getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf((String)typeAttr);
        }
        return type;
    }

    public static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return XmlUtils.getOptionalTypeAttribute(element, attributeName, null);
    }

    public static Optional<Type> getOptionalType(Element element, String attributeName) {
        return XmlUtils.getOptionalString(element, attributeName).map(Type::valueOf);
    }

    public static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return XmlUtils.getOptionalBoolean(element, attributeName).orElse(defaultValue);
    }

    public static Optional<Boolean> getOptionalBoolean(Element element, String attributeName) {
        return XmlUtils.getOptionalString(element, attributeName).map(Boolean::valueOf);
    }

    public static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        return XmlUtils.getOptionalString(element, attributeName).orElse(defaultValue);
    }

    public static Optional<String> getOptionalString(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return Optional.ofNullable(element.getAttribute(attributeName));
        }
        return Optional.empty();
    }

    public static Iterable<Element> childrenByName(final Element element, final Predicate<String> matcher) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return XmlUtils.childByName(element, matcher);
            }
        };
    }

    public static Iterator<Element> childByName(final Element element, final Predicate<String> matcher) {
        return new Iterator<Element>(){
            private int i = -1;
            private NodeList childNodes = element.getChildNodes();
            private int nextIndex = -1;

            @Override
            public boolean hasNext() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                return this.nextIndex > this.i;
            }

            @Override
            public Element next() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                if (this.nextIndex < this.i) {
                    throw new NoSuchElementException("There are no more matching elements");
                }
                this.i = this.nextIndex;
                return (Element)this.childNodes.item(this.i);
            }

            private int findNext() {
                int next = this.i;
                while (next < this.childNodes.getLength()) {
                    Element e;
                    if (!(this.childNodes.item(++next) instanceof Element) || !matcher.test((e = (Element)this.childNodes.item(next)).getNodeName())) continue;
                    return next;
                }
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.call(iterator.next());
        }
    }

    public static interface Closure<E> {
        public void call(E var1);
    }
}

