package com.xebialabs.json_patch

import java.io.{ByteArrayInputStream, InputStream}

import com.fasterxml.jackson.databind.JsonNode
import com.flipkart.zjsonpatch.JsonPatch
import grizzled.slf4j.Logging

class YamlPatch extends Logging with JsonSupport {
  def applyPatchOnYaml(patchInput: String, sourceYaml: InputStream): InputStream = {
    val jsonNode = yamlMapper.readTree(sourceYaml)
    applyPatchOnYaml(patchInput, jsonNode)
  }

  def applyPatchOnYaml(patchInput: String, jsonNode: JsonNode): InputStream = {
    val patchJson: JsonNode = jsonMapper.readTree(patchInput)
    new ByteArrayInputStream(applyPatchOnYaml(patchJson, jsonNode).getBytes)
  }

  def applyPatchOnYaml(patch: String, sourceYaml: String): String = {
    val patchJson: JsonNode = jsonMapper.readTree(patch)
    val jsonNode = yamlMapper.readTree(sourceYaml)
    applyPatchOnYaml(patchJson, jsonNode)
  }

  private def applyPatchOnYaml(patchJson: JsonNode, jsonNode: JsonNode): String = {
    val result = Option(patchJson)
      .map(Utils.transformValues(yamlMapper, _))
      .map(JsonPatch.apply(_, jsonNode))
      .getOrElse(jsonNode)
    yamlMapper.writerWithDefaultPrettyPrinter.writeValueAsString(result)
  }
}
