package com.xebialabs.json_patch

import com.fasterxml.jackson.core.JsonParseException
import com.fasterxml.jackson.databind.node.{ArrayNode, NullNode, ObjectNode}
import com.fasterxml.jackson.databind.{JsonNode, ObjectMapper}

import scala.collection.convert.ImplicitConversions._
import scala.util.Try

object Utils {
  def transformValue(mapper: ObjectMapper, valueNode: JsonNode): JsonNode =
    valueNode match {
      case nullNode: NullNode => nullNode
      case _ => Try {
        mapper.readTree(valueNode.textValue())
      }.recover {
        case _: JsonParseException => valueNode
      }.get
    }

  def transformValues(mapper: ObjectMapper, node: JsonNode): JsonNode = node match {
    case array: ArrayNode =>
      val result = mapper.createArrayNode()
      array.elements().foreach(node => {
        val newNode = node.deepCopy[ObjectNode]()
        Option(newNode.get("value")).foreach { valueNode =>
          newNode.set("value", transformValue(mapper, valueNode))
        }
        result.add(newNode)
      })
      result
    case _@other => other
  }
}
