package com.xebialabs.json_patch

import java.io.{ByteArrayInputStream, InputStream}

import com.fasterxml.jackson.databind.JsonNode
import com.flipkart.zjsonpatch.{JsonPatch => FlipkartJsonPatch}
import grizzled.slf4j.Logging

class JsonPatch extends Logging with JsonSupport {
  def applyPatchOnJson(patchInput: String, sourceJson: InputStream): InputStream = {
    val sourceJsonObj = jsonMapper.readTree(sourceJson)
    applyPatchOnJson(patchInput, sourceJsonObj)
  }

  def applyPatchOnJson(patchInput: String, sourceJsonObj: JsonNode): InputStream = {
    val patchJsonObj = jsonMapper.readTree(patchInput)
    new ByteArrayInputStream(applyPatchOnJson(patchJsonObj, sourceJsonObj).getBytes)
  }

  def applyPatchOnJson(patch: String, sourceJson: String): String = {
    val patchJsonObj = jsonMapper.readTree(patch)
    val sourceJsonObj = jsonMapper.readTree(sourceJson)
    applyPatchOnJson(patchJsonObj, sourceJsonObj)
  }

  private def applyPatchOnJson(patchJsonObj: JsonNode, sourceJsonObj: JsonNode): String = {
    val result = Option(patchJsonObj)
      .map(Utils.transformValues(jsonMapper, _))
      .map(FlipkartJsonPatch.apply(_, sourceJsonObj))
      .getOrElse(sourceJsonObj)
    jsonMapper.writerWithDefaultPrettyPrinter.writeValueAsString(result)
  }
}
