/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.ServerInfo;
import com.xebialabs.deployit.engine.api.dto.ServerPluginInfo;

public class ServerInfoJsonConverter {

    public String toJson(ServerInfo serverInfo) {
        JsonWriter writer = new JsonWriter();
        toJson(serverInfo, writer);
        return writer.toString();
    }

    public void toJson(final ServerInfo serverInfo, final JsonWriter writer) {
        writer.object();

        writer.key("version").value(serverInfo.getVersion());

        writer.key("classpath-entries").array();
        serverInfo.getClasspathEntries().forEach(writer::value);
        writer.endArray();

        writer.key("plugins-info").array();
        for (ServerPluginInfo pluginInfo : serverInfo.getPluginsInfo()) {
            writer.object();
            writer.key("plugin").value(pluginInfo.getPlugin());
            writer.key("version").value(pluginInfo.getVersion());
            writer.endObject();
        }
        writer.endArray();

        writer.endObject();
    }
}
