/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.engine.api.dto.Deployment;
import com.xebialabs.deployit.engine.api.dto.SelectedDeployment;
import com.xebialabs.xltype.serialization.json.DeploymentJsonConverter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SelectedDeploymentJsonConverter {
    public static final String DEPLOYABLE_IDS = "mapping-for-deployables";
    public static final String DEPLOYMENT = "deployment";
    private DeploymentJsonConverter deploymentJsonConverter;

    public SelectedDeploymentJsonConverter(DeploymentJsonConverter deploymentJsonConverter) {
        this.deploymentJsonConverter = deploymentJsonConverter;
    }

    public String toJson(SelectedDeployment selectedDeployment) {
        JsonWriter writer = new JsonWriter();
        this.toJson(selectedDeployment, writer);
        return writer.toString();
    }

    public void toJson(SelectedDeployment selectedDeployment, JsonWriter writer) {
        writer.object();
        this.writeSelectedDeployeds(selectedDeployment, writer);
        this.writeDeployment(selectedDeployment, writer);
        writer.endObject();
    }

    private void writeSelectedDeployeds(SelectedDeployment deployment, JsonWriter writer) {
        if (!deployment.getSelectedDeployableIds().isEmpty()) {
            writer.key(DEPLOYABLE_IDS);
            writer.array();
            for (String id : deployment.getSelectedDeployableIds()) {
                writer.value(id);
            }
            writer.endArray();
        }
    }

    private void writeDeployment(SelectedDeployment selectedDeployment, JsonWriter writer) {
        writer.key(DEPLOYMENT);
        this.deploymentJsonConverter.toJson(selectedDeployment.getDeployment(), writer);
    }

    public SelectedDeployment toSelectedDeployment(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            Preconditions.checkArgument((boolean)json.has(DEPLOYABLE_IDS), (String)"Missing '%s' property in JSON:\n%s", (Object[])new Object[]{DEPLOYABLE_IDS, jsonString});
            Preconditions.checkArgument((boolean)json.has(DEPLOYMENT), (String)"Missing '%s' property in JSON:\n%s", (Object[])new Object[]{DEPLOYMENT, jsonString});
            List<String> selectedDeployables = this.readSelectedDeployables(json);
            Deployment deployment = this.deploymentJsonConverter.toDeployment(json.getJSONObject(DEPLOYMENT));
            return new SelectedDeployment(selectedDeployables, deployment);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    public List<String> readSelectedDeployables(JSONObject json) throws JSONException {
        ArrayList<String> selectedDeployablesIds = new ArrayList<String>();
        JSONArray selectedDeployables = json.getJSONArray(DEPLOYABLE_IDS);
        for (int i = 0; i < selectedDeployables.length(); ++i) {
            selectedDeployablesIds.add(selectedDeployables.getString(i));
        }
        return selectedDeployablesIds;
    }
}

