package com.xebialabs.xltype.serialization.xstream;

import java.util.List;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;

public abstract class AbstractBlockConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        BlockState block = (BlockState) source;

        if (block instanceof StepBlockState) {
            Converters.writeStepBlock((StepBlockState) block, writer, context);
        } else if (block instanceof CompositeBlockState) {
            Converters.writeBlockTree(block, writer, context, false);
        }
    }

    @Override
    public boolean canConvert(final Class type) {
        return BlockState.class.isAssignableFrom(type);
    }

}
