package com.xebialabs.xltype.serialization.xstream;

import java.util.List;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.TaskPreview;

import static com.google.common.collect.Lists.newArrayList;

@XStreamProvider(readable = TaskPreview.class, tagName = "preview")
public class TaskPreviewConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskPreview preview = (TaskPreview) source;
        writer.addAttribute("id", preview.getId());
        writer.startNode("steps");
        for (StepState stepState : preview.getSteps()) {
            writer.startNode("step");
            context.convertAnother(stepState);
            writer.endNode();
        }
        writer.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TaskPreview taskPreview = new TaskPreview();
        taskPreview.setId(reader.getAttribute("id"));
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("steps")) {
                taskPreview.setSteps(Converters.readList(null, StepState.class, reader, context));
            }
            reader.moveUp();
        }
        return taskPreview;
    }

    @Override
    public boolean canConvert(Class type) {
        return TaskPreview.class.isAssignableFrom(type);
    }
}
