package com.xebialabs.xltype.serialization.xstream;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;

import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;

import static com.google.common.collect.Lists.newArrayList;

public class CiXstreamReader implements CiReader, CiListReader {

    private final HierarchicalStreamReader reader;

    public CiXstreamReader(HierarchicalStreamReader reader) {
        this.reader = reader;
    }

    @Override
    public String getType() {
        return reader.getNodeName();
    }

    @Override
    public String getId() {
        return reader.getAttribute("id");
    }

    @Override
    public String getToken() {
        return reader.getAttribute("token");
    }

    @Override
    public boolean hasMoreProperties() {
        return reader.hasMoreChildren();
    }

    @Override
    public void moveIntoProperty() {
        reader.moveDown();
    }

    @Override
    public CiReader moveIntoNestedProperty() {
        reader.moveDown();
        return this;
    }

    @Override
    public void moveOutOfProperty() {
        reader.moveUp();
    }

    @Override
    public String getCurrentPropertyName() {
        return reader.getNodeName();
    }

    @Override
    public String getStringValue() {
        return reader.getValue();
    }

    @Override
    public List<String> getStringValues() {
        List<String> strings = new ArrayList<String>();

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            strings.add(reader.getValue());
            reader.moveUp();
        }

        return strings;
    }

    @Override
    public Map<String, String> getStringMap() {
        Map<String, String> map = new LinkedHashMap<String, String>();

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getAttribute("key"), reader.getValue());
            reader.moveUp();
        }

        return map;
    }

    @Override
    public boolean isCiReference() {
        return reader.getAttribute("ref") != null;
    }

    @Override
    public String getCiReference() {
        return reader.getAttribute("ref");
    }

    @Override
    public List<String> getCiReferences() {
        List<String> references = new ArrayList<String>();

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            references.add(getCiReference());
            reader.moveUp();
        }

        return references;
    }

    @Override
    public CiListReader getCurrentCiListReader() {
        return this;
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        List<ValidationMessage> messages = newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            messages.add(new ValidationMessage(reader.getAttribute("ci"), reader.getAttribute("property"), getStringValue()));
            reader.moveUp();
        }

        return messages;
    }

    @Override
    public boolean hasMoreChildren() {
        return reader.hasMoreChildren();
    }

    @Override
    public void moveIntoChild() {
        reader.moveDown();
    }

    @Override
    public void moveOutOfChild() {
        reader.moveUp();
    }

    @Override
    public CiReader getCurrentCiReader() {
        return this;
    }
}
