package com.xebialabs.xltype.serialization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public final class CiReference {

    private final ConfigurationItem ci;
    private final PropertyDescriptor property;
    private final List<String> ids = new ArrayList<String>();

    public CiReference(ConfigurationItem ci, PropertyDescriptor property, List<String> ids) {
        this.ci = ci;
        this.property = property;
        this.ids.addAll(ids);
    }

    public CiReference(ConfigurationItem owner, PropertyDescriptor property, String reference) {
        this.ci = owner;
        this.property = property;
        this.ids.add(reference);
    }

    public ConfigurationItem getCi() {
        return ci;
    }

    public PropertyDescriptor getProperty() {
        return property;
    }

    public List<String> getIds() {
        return ids;
    }

    public void set(List<ConfigurationItem> cis) {
        switch (property.getKind()) {
        case LIST_OF_CI:
            property.set(ci, cis);
            break;
        case SET_OF_CI:
            property.set(ci, new HashSet<ConfigurationItem>(cis));
            break;
        case CI:
            if (cis.size() > 0) {
                property.set(ci, cis.get(0));
            } else {
                property.set(ci, null);
            }
            break;
        default:
            throw new IllegalStateException("Can't set CI reference of kind " + property.getKind());
        }
    }

    @Override
    public String toString() {
        return String.format("%s=>%s = %s", ci.getId(), property.getName(), ids);
    }
}
