/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.google.common.collect.Lists;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.SerializationException;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CiListJsonReader
implements CiListReader {
    private Iterator<JSONObject> iterator;
    private JSONObject currentObject;

    public CiListJsonReader(JSONArray json) {
        try {
            this.iterator = CiListJsonReader.toObjectList(json).iterator();
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public static CiListJsonReader create(String jsonArray) {
        try {
            return new CiListJsonReader(new JSONArray(jsonArray));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse the following as a JSON array:\n" + jsonArray, e);
        }
    }

    @Override
    public boolean hasMoreChildren() {
        return this.iterator.hasNext();
    }

    @Override
    public void moveIntoChild() {
        this.currentObject = this.iterator.next();
    }

    @Override
    public void moveOutOfChild() {
    }

    @Override
    public CiReader getCurrentCiReader() {
        CiJsonReader currentReader = new CiJsonReader(this.currentObject);
        if (this.currentObject.has("ci-ref")) {
            currentReader.moveIntoProperty();
        }
        return currentReader;
    }

    private static List<JSONObject> toObjectList(JSONArray array) throws JSONException {
        ArrayList objects = Lists.newArrayListWithCapacity((int)array.length());
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonObject = array.optJSONObject(i);
            if (jsonObject == null) {
                jsonObject = new JSONObject();
                jsonObject.put("ci-ref", (Object)array.getString(i));
            }
            objects.add(jsonObject);
        }
        return objects;
    }
}

