/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.xml.Converters;
import com.xebialabs.deployit.engine.xml.XStreamProvider;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

@XStreamProvider(readable=Control.class, tagName="control")
public class ControlConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Control c = (Control)source;
        writer.addAttribute("method", c.getControlName());
        writer.startNode("controllable");
        Converters.writeConfigurationItem(c.getConfigurationItem(), writer, context);
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String controlName = reader.getAttribute("method");
        ConfigurationItem ci = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("controllable".equals(reader.getNodeName())) {
                reader.moveDown();
                ci = (ConfigurationItem)context.convertAnother(null, ConfigurationItem.class);
            }
            reader.moveUp();
        }
        return new Control(ci, controlName);
    }

    public boolean canConvert(Class type) {
        return Control.class.isAssignableFrom(type);
    }
}

