package com.xebialabs.deployit.engine.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import static com.xebialabs.deployit.engine.xml.Converters.writeConfigurationItem;

@XStreamProvider(readable = Inspection.class, tagName = "inspection")
public class InspectionConverter implements Converter {
    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Inspection i = (Inspection) source;
        writer.startNode("inspectable");
        writeConfigurationItem(i.getConfigurationItem(), writer, context);
        writer.endNode();
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ConfigurationItem ci = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("inspectable".equals(reader.getNodeName())) {
                reader.moveDown();
                ci = (ConfigurationItem) context.convertAnother(null, ConfigurationItem.class);
            }
            reader.moveUp();
        }
        return new Inspection(ci);
    }

    @Override
    public boolean canConvert(Class type) {
        return Inspection.class.isAssignableFrom(type);
    }
}
