/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemIdAndReferenceId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.udm.ExternalProperty;
import com.xebialabs.deployit.plugin.api.udm.lookup.LookupValueKey;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiJsonWriter
implements CiWriter {
    protected final Writer writer;
    protected final JsonWriter json;
    protected final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();

    public CiJsonWriter() {
        this(new StringWriter());
    }

    public CiJsonWriter(Writer writer) {
        this.writer = writer;
        this.json = new JsonWriter(writer);
    }

    public CiJsonWriter(JsonWriter json) {
        this.json = json;
        this.writer = json.getWriter();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.writer.toString();
    }

    @Override
    public void startList() {
        this.json.array();
    }

    @Override
    public void endList() {
        this.json.endArray();
    }

    @Override
    public void startCi(String type, String id) {
        this.json.object();
        this.json.key("id").value(id);
        this.json.key("type").value(type);
    }

    @Override
    public void endCi() {
        this.json.endObject();
    }

    @Override
    public void token(String token) {
        this.json.key("$token").value(token != null ? token : "");
    }

    @Override
    public void ciAttributes(CiAttributes ciAttributes) {
        this.addStringAttribute("$createdBy", ciAttributes.getCreatedBy());
        this.addDateAttribute("$createdAt", ciAttributes.getCreatedAt());
        this.addStringAttribute("$lastModifiedBy", ciAttributes.getLastModifiedBy());
        this.addDateAttribute("$lastModifiedAt", ciAttributes.getLastModifiedAt());
        this.addStringAttribute("$scmTraceabilityDataId", ciAttributes.getScmTraceabilityDataId());
    }

    @Override
    public void ciFileAttribute(String file) {
        this.addStringAttribute("file", file);
    }

    private void addStringAttribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.json.key(attrName).value(attrValue);
        }
    }

    private void addDateAttribute(String attrName, DateTime attrValue) {
        if (attrValue != null) {
            this.json.key(attrName).value(this.dateTimeAdapter.marshal(attrValue));
        }
    }

    @Override
    public void startProperty(String name) {
        this.json.key(name);
    }

    @Override
    public void endProperty() {
    }

    @Override
    public void valueAsString(Object value) {
        this.json.value(value);
    }

    @Override
    public void valuesAsStrings(Collection<?> values) {
        this.json.array();
        for (Object item : values) {
            this.valueAsString(item);
        }
        this.json.endArray();
    }

    @Override
    public void mapAsStrings(Map<?, ?> map) {
        this.json.object();
        for (Object key : map.keySet()) {
            this.json.key(String.valueOf(key));
            this.valueAsString(map.get(key));
        }
        this.json.endObject();
    }

    @Override
    public void ciReference(String reference) {
        this.valueAsString(reference);
    }

    @Override
    public void ciReferences(Collection<String> references) {
        this.valuesAsStrings(references);
    }

    @Override
    public void typedCiReference(ConfigurationItemId ci) {
        this.json.object();
        this.json.key("ci").value(ci.getId());
        if (ci.getType() != null) {
            this.json.key("type").value(ci.getType());
        }
        if (ci instanceof ConfigurationItemIdAndReferenceId) {
            this.json.key("$referenceId").value(((ConfigurationItemIdAndReferenceId)ci).getReferenceId());
        }
        this.json.endObject();
    }

    @Override
    public void typedCiReferences(Collection<? extends ConfigurationItemId> references) {
        this.json.array();
        for (ConfigurationItemId configurationItemId : references) {
            this.typedCiReference(configurationItemId);
        }
        this.json.endArray();
    }

    @Override
    public void validationMessages(List<ValidationMessage> validations) {
        this.json.key("validation-messages");
        this.json.array();
        for (ValidationMessage validation : validations) {
            this.json.object();
            this.json.key("level").value(validation.getLevel().name());
            this.json.key("ci").value(validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.json.key("property").value(validation.getPropertyName());
            }
            this.json.key("message").value(validation.getMessage());
            this.json.endObject();
        }
        this.json.endArray();
    }

    @Override
    public void externalProperties(Map<String, ExternalProperty> externalProperties) {
        this.json.key("external-properties");
        this.json.object();
        for (Map.Entry<String, ExternalProperty> entry : externalProperties.entrySet()) {
            this.json.key(entry.getKey());
            this.json.object();
            ExternalProperty externalProperty = entry.getValue();
            if (externalProperty instanceof LookupValueKey) {
                LookupValueKey lookupValueKey = (LookupValueKey)externalProperty;
                this.json.key("kind").value("lookup");
                this.json.key("key").value(lookupValueKey.getKey());
                this.json.key("provider").value(lookupValueKey.getProviderId());
            }
            this.json.endObject();
        }
        this.json.endObject();
    }
}

