/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.rest;

import javax.ws.rs.ext.ParamConverter;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LocalDateParamConverter implements ParamConverter<LocalDate> {

    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");

    @Override
    public LocalDate fromString(String yyyyMMdd) {
        return LocalDate.parse(yyyyMMdd, DATE_FORMAT);
    }

    @Override
    public String toString(LocalDate value) {
        return DATE_FORMAT.print(value);
    }
}
