/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;

import java.util.Map;

public class StepStateJsonConverter extends JsonConverter<StepState> {

    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();

    public JsonWriter writeJsonObject(StepState step, JsonWriter writer) {
        writer.object();
        writer.key("state").value(step.getState());
        writer.key("failures").value(step.getFailureCount());
        writer.key("description").value(step.getDescription());
        writer.key("skippable").value(step.getSkippable());

        if (step.getStartDate() != null) {
            writer.key("startDate").value(timeAdapter.marshal(step.getStartDate()));
        }
        if (step.getCompletionDate() != null) {
            writer.key("completionDate").value(timeAdapter.marshal(step.getCompletionDate()));
        }

        if (step.getPreviousAttemptsLogs() != null) { // cf. StepStateOptimized
            writer.key("previousAttemptsLogs").array();
            step.getPreviousAttemptsLogs().forEach(writer::value);
            writer.endArray();
        }
        if (step.getLog() != null) {
            writer.key("log").value(step.getLog());
        }

        if (step.getMetadata() != null && !step.getMetadata().isEmpty()) {
            writer.key("metadata").object();
            for (Map.Entry<String, String> metadata : step.getMetadata().entrySet()){
                writer.key(metadata.getKey()).value(metadata.getValue());
            }
            writer.endObject();
        }
        writer.endObject();

        return writer;
    }
}
