/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream

import com.thoughtworks.xstream.converters.{Converter, MarshallingContext, UnmarshallingContext}
import com.thoughtworks.xstream.io.{HierarchicalStreamReader, HierarchicalStreamWriter}
import com.xebialabs.deployit.engine.api.dto.{TaskPathStatus, TaskStepLog}

@XStreamProvider(readable = classOf[TaskStepLog], tagName = "taskStepLog")
class TaskStepLogWriter extends Converter {
  override def marshal(source: Any, writer: HierarchicalStreamWriter, context: MarshallingContext): Unit = {
    val taskStepLog = source.asInstanceOf[TaskStepLog]
    writer.addAttribute("taskId", taskStepLog.taskId)
    writer.addAttribute("stepPath", taskStepLog.stepPath)
    writer.addAttribute("log", taskStepLog.log)
  }

  override def unmarshal(reader: HierarchicalStreamReader, context: UnmarshallingContext): AnyRef = {
    val taskId = reader.getAttribute("taskId")
    val stepPath = reader.getAttribute("stepPath")
    val log = reader.getAttribute("log")
    TaskStepLog(taskId, stepPath, log)
  }

  override def canConvert(`type`: Class[_]): Boolean = classOf[TaskStepLog].isAssignableFrom(`type`)
}
